/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLDocument;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.fabric8.elasticsearch.plugin.kibana.KibanaSeed;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class DynamicACLFilter
extends RestFilter
implements ConfigurationSettings {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final ESLogger logger;
    private final UserProjectCache cache;
    private final String proxyUserHeader;
    private final String searchGuardIndex;
    private final String kibanaIndex;
    private final String kibanaVersion;
    private final String userProfilePrefix;
    private final Settings settings;
    private final ReentrantLock lock = new ReentrantLock();
    private final String kbnVersionHeader;
    private final String[] operationsProjects;
    private Boolean enabled;
    private final String cdmProjectPrefix;
    private KibanaSeed kibanaSeed;
    private final Client client;

    @Inject
    public DynamicACLFilter(UserProjectCache cache, Settings settings, KibanaSeed seed, Client client) {
        this.client = client;
        this.cache = cache;
        this.kibanaSeed = seed;
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
        this.searchGuardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.userProfilePrefix = settings.get("io.fabric8.elasticsearch.acl.user_profile_prefix", ".kibana");
        this.kibanaIndex = settings.get("kibana.config_index_name", ".kibana");
        this.kibanaVersion = settings.get("kibana.version", "4.5.1");
        this.kbnVersionHeader = settings.get("kibana.version.header", "kbn-version");
        this.operationsProjects = settings.getAsArray("openshift.operations.project.names", DEFAULT_OPENSHIFT_OPS_PROJECTS);
        this.cdmProjectPrefix = settings.get("openshift.config.project_index_prefix", "");
        this.logger.debug("searchGuardIndex: {}", new Object[]{this.searchGuardIndex});
        this.settings = settings;
        this.enabled = settings.getAsBoolean("openshift.acl.dynamic.enabled", Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        boolean continueProcessing = true;
        try {
            if (this.enabled.booleanValue()) {
                String kbnVersion = this.getKibanaVersion(request);
                if (StringUtils.isEmpty((String)kbnVersion)) {
                    kbnVersion = this.kibanaVersion;
                }
                String user = this.getUser(request);
                String token = this.getBearerToken(request);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Handling Request... {}", new Object[]{request.uri()});
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Request headers: {}", new Object[]{request.headers()});
                        this.logger.trace("Request context: {}", new Object[]{request.getContext()});
                    }
                    this.logger.debug("Evaluating request for user '{}' with a {} token", new Object[]{user, StringUtils.isNotEmpty((String)token) ? "non-empty" : "empty"});
                    this.logger.debug("Cache has user: {}", new Object[]{this.cache.hasUser(user, token)});
                }
                if (StringUtils.isNotEmpty((String)token) && StringUtils.isNotEmpty((String)user) && !this.cache.hasUser(user, token)) {
                    boolean isOperationsUser = this.isOperationsUser(user, token);
                    if (isOperationsUser) {
                        request.putInContext((Object)"X-OpenShift-Roles", (Object)"cluster-admin");
                    }
                    if (this.updateCache(user, token, isOperationsUser, kbnVersion)) {
                        this.syncAcl();
                    }
                }
            }
        }
        catch (ElasticsearchSecurityException ese) {
            this.logger.info("Could not authenticate user", new Object[0]);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED));
            continueProcessing = false;
        }
        catch (Exception e) {
            this.logger.error("Error handling request in {}", (Throwable)e, new Object[]{this.getClass().getSimpleName()});
        }
        finally {
            if (continueProcessing) {
                chain.continueProcessing(request, channel);
            }
        }
    }

    private String getUser(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.proxyUserHeader), (Object)"");
    }

    private String getBearerToken(RestRequest request) {
        String[] auth = ((String)ObjectUtils.defaultIfNull((Object)request.header(AUTHORIZATION_HEADER), (Object)"")).split(" ");
        if (auth.length >= 2 && "Bearer".equals(auth[0])) {
            return auth[1];
        }
        return "";
    }

    private String getKibanaVersion(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.kbnVersionHeader), (Object)"");
    }

    private boolean updateCache(String user, String token, boolean isOperationsUser, String kbnVersion) {
        this.logger.debug("Updating the cache for user '{}'", new Object[]{user});
        try {
            Set<String> projects = this.listProjectsFor(token);
            this.cache.update(user, token, projects, isOperationsUser);
            HashSet<String> roles = new HashSet<String>();
            if (isOperationsUser) {
                roles.add("operations-user");
            }
            this.kibanaSeed.setDashboards(user, projects, roles, this.client, this.kibanaIndex, kbnVersion, this.cdmProjectPrefix, this.settings);
        }
        catch (KubernetesClientException e) {
            this.logger.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
            throw new ElasticsearchSecurityException(e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
            return false;
        }
        return true;
    }

    private Set<String> listProjectsFor(String token) throws Exception {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        HashSet<String> names = new HashSet<String>();
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient(builder.build());){
            List projects = ((ProjectList)client.projects().list()).getItems();
            for (Project project : projects) {
                if (this.isBlacklistProject(project.getMetadata().getName())) continue;
                names.add(project.getMetadata().getName() + "." + project.getMetadata().getUid());
            }
        }
        return names;
    }

    private boolean isBlacklistProject(String project) {
        return ArrayUtils.contains((Object[])this.operationsProjects, (Object)project.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOperationsUser(String user, String token) {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        boolean allowed = false;
        try (DefaultOpenShiftClient osClient = new DefaultOpenShiftClient(builder.build());){
            this.logger.debug("Submitting a SAR to see if '{}' is able to retrieve logs across the cluster", new Object[]{user});
            SubjectAccessReviewResponse response = (SubjectAccessReviewResponse)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((NamespacedOpenShiftClient)osClient.inAnyNamespace()).subjectAccessReviews().createNew()).withVerb("get")).withResource("pods/log")).done();
            allowed = response.getAllowed();
        }
        catch (Exception e) {
            try {
                this.logger.error("Exception determining user's '{}' role.", (Throwable)e, new Object[]{user});
            }
            catch (Throwable throwable) {
                this.logger.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
                throw throwable;
            }
            this.logger.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
        }
        this.logger.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAcl() {
        this.logger.debug("Syncing the ACL to ElasticSearch", new Object[0]);
        try {
            this.lock.lock();
            this.logger.debug("Loading SearchGuard ACL...", new Object[0]);
            MultiGetRequest mget = new MultiGetRequest();
            mget.putHeader("_sg_conf_request", (Object)"true");
            mget.refresh(true);
            mget.realtime(Boolean.valueOf(true));
            mget.add(this.searchGuardIndex, "roles", "0");
            mget.add(this.searchGuardIndex, "rolesmapping", "0");
            SearchGuardRoles roles = null;
            SearchGuardRolesMapping rolesMapping = null;
            MultiGetResponse response = (MultiGetResponse)this.client.multiGet(mget).actionGet();
            for (MultiGetItemResponse item : response.getResponses()) {
                if (!item.isFailed()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Read in {}: {}", new Object[]{item.getType(), XContentHelper.convertToJson((BytesReference)item.getResponse().getSourceAsBytesRef(), (boolean)true, (boolean)true)});
                    }
                    switch (item.getType()) {
                        case "roles": {
                            roles = new SearchGuardRoles().load(item.getResponse().getSource());
                            break;
                        }
                        case "rolesmapping": {
                            rolesMapping = new SearchGuardRolesMapping().load(item.getResponse().getSource());
                        }
                    }
                    continue;
                }
                this.logger.error("There was a failure loading document type {}", new Object[]{item.getFailure(), item.getType()});
            }
            if (roles == null || rolesMapping == null) {
                return;
            }
            this.logger.debug("Syncing from cache to ACL...", new Object[0]);
            roles.syncFrom(this.cache, this.userProfilePrefix, this.cdmProjectPrefix);
            rolesMapping.syncFrom(this.cache, this.userProfilePrefix);
            this.writeAcl(roles, rolesMapping);
        }
        catch (Exception e) {
            this.logger.error("Exception while syncing ACL with cache", (Throwable)e, new Object[0]);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeAcl(SearchGuardACLDocument ... documents) throws Exception {
        BulkRequestBuilder builder = this.client.prepareBulk().setRefresh(true);
        for (SearchGuardACLDocument doc : documents) {
            UpdateRequest update = (UpdateRequest)this.client.prepareUpdate(this.searchGuardIndex, doc.getType(), "0").setConsistencyLevel(WriteConsistencyLevel.DEFAULT).setDoc(doc.toXContentBuilder()).request();
            builder.add(update);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Built {} update request: {}", new Object[]{doc.getType(), XContentHelper.convertToJson((BytesReference)doc.toXContentBuilder().bytes(), (boolean)true, (boolean)true)});
        }
        BulkRequest request = (BulkRequest)builder.request();
        request.putHeader("_sg_conf_request", (Object)"true");
        BulkResponse response = (BulkResponse)this.client.bulk(request).actionGet();
        if (!response.hasFailures()) {
            ConfigUpdateRequest confRequest = new ConfigUpdateRequest(SEARCHGUARD_INITIAL_CONFIGS);
            confRequest.putHeader("_sg_conf_request", (Object)"true");
            ConfigUpdateResponse cur = (ConfigUpdateResponse)this.client.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)confRequest).actionGet();
            if (((ConfigUpdateResponse.Node[])cur.getNodes()).length > 0) {
                this.logger.debug("Successfully reloaded config with '{}' nodes", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length});
            } else {
                this.logger.warn("Failed to reloaded configs", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length});
            }
        } else {
            this.logger.error("Unable to write ACL {}", new Object[]{response.buildFailureMessage()});
        }
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

