/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import com.google.common.collect.Lists;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.KibanaUserReindexAction;
import io.fabric8.elasticsearch.plugin.OpenShiftElasticSearchModule;
import io.fabric8.elasticsearch.plugin.OpenShiftElasticSearchService;
import io.fabric8.elasticsearch.rest.KibanaUserRestHandler;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.transport.TransportModule;

public class OpenShiftElasticSearchPlugin
extends Plugin
implements ConfigurationSettings {
    private final Settings settings;
    private final SearchGuardPlugin searchguard;
    private final SearchGuardSSLPlugin sgSSL;

    @Inject
    public OpenShiftElasticSearchPlugin(Settings settings) {
        System.setProperty("sg.nowarn.client", "true");
        this.settings = settings;
        this.sgSSL = new SearchGuardSSLPlugin(this.settings);
        this.searchguard = new SearchGuardPlugin(this.settings);
    }

    public String name() {
        return "openshift-elasticsearch-plugin";
    }

    public String description() {
        return "OpenShift ElasticSearch Plugin";
    }

    public void onModule(ActionModule actionModule) {
        actionModule.registerFilter(KibanaUserReindexAction.class);
        this.searchguard.onModule(actionModule);
    }

    public void onModule(RestModule restModule) {
        this.searchguard.onModule(restModule);
        this.sgSSL.onModule(restModule);
        restModule.addRestAction(KibanaUserRestHandler.class);
    }

    public void onModule(TransportModule module) {
        this.searchguard.onModule(module);
        this.sgSSL.onModule(module);
    }

    public void onModule(HttpServerModule module) {
        this.searchguard.onModule(module);
        this.sgSSL.onModule(module);
    }

    public Collection<Module> shardModules(Settings indexSettings) {
        ArrayList modules = Lists.newArrayList();
        modules.addAll(this.searchguard.shardModules(indexSettings));
        modules.addAll(this.sgSSL.shardModules(indexSettings));
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> nodeServices() {
        ArrayList services = Lists.newArrayList();
        services.addAll(this.searchguard.nodeServices());
        services.addAll(this.sgSSL.nodeServices());
        services.add(OpenShiftElasticSearchService.class);
        return services;
    }

    public Collection<Module> nodeModules() {
        ArrayList modules = Lists.newArrayList();
        modules.addAll(this.searchguard.nodeModules());
        modules.addAll(this.sgSSL.nodeModules());
        modules.add(new OpenShiftElasticSearchModule());
        return modules;
    }

    public Collection<Module> indexModules(Settings indexSettings) {
        ArrayList modules = Lists.newArrayList();
        modules.addAll(this.searchguard.indexModules(indexSettings));
        modules.addAll(this.sgSSL.indexModules(indexSettings));
        return modules;
    }

    public Collection<Class<? extends Closeable>> indexServices() {
        ArrayList services = Lists.newArrayList();
        services.addAll(this.searchguard.indexServices());
        services.addAll(this.sgSSL.indexServices());
        return services;
    }

    public Collection<Class<? extends Closeable>> shardServices() {
        ArrayList services = Lists.newArrayList();
        services.addAll(this.searchguard.shardServices());
        services.addAll(this.sgSSL.shardServices());
        return services;
    }

    public Settings additionalSettings() {
        Settings.Builder settingsBuilder = Settings.builder().put(this.settings).put(this.searchguard.additionalSettings()).put(this.sgSSL.additionalSettings());
        return settingsBuilder.build();
    }
}

