/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.configuration.ConfigChangeListener;
import com.floragunn.searchguard.http.RemoteIpDetector;
import java.net.InetSocketAddress;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.rest.RestRequest;

public class XFFResolver
implements ConfigChangeListener {
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private volatile Settings settings;
    private volatile boolean enabled;
    private volatile RemoteIpDetector detector;

    @Inject
    public XFFResolver(TransportConfigUpdateAction tcua) {
        tcua.addConfigChangeListener("config", this);
    }

    public TransportAddress resolve(RestRequest request) throws ElasticsearchSecurityException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolve {}", new Object[]{request.getRemoteAddress()});
        }
        if (this.isInitialized() && this.enabled && request.getRemoteAddress() instanceof InetSocketAddress && request instanceof NettyHttpRequest) {
            InetSocketAddress isa = new InetSocketAddress(this.detector.detect((NettyHttpRequest)request), ((InetSocketAddress)request.getRemoteAddress()).getPort());
            if (isa.isUnresolved()) {
                throw new ElasticsearchSecurityException("Cannot resolve address " + isa.getHostString(), new Object[0]);
            }
            if (this.log.isTraceEnabled()) {
                if (request.getFromContext((Object)"_sg_xff_done") == Boolean.TRUE) {
                    this.log.trace("xff resolved {} to {}", new Object[]{request.getRemoteAddress(), isa});
                } else {
                    this.log.trace("no xff done for {}", new Object[]{request.getClass()});
                }
            }
            return new InetSocketTransportAddress(isa);
        }
        if (request.getRemoteAddress() instanceof InetSocketAddress) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("no xff done (not initialized, enabled or no netty request) {},{},{},{}", new Object[]{this.isInitialized(), this.enabled, request.getClass()});
            }
            return new InetSocketTransportAddress((InetSocketAddress)request.getRemoteAddress());
        }
        throw new ElasticsearchSecurityException("Cannot handle this request. Remote address is " + request.getRemoteAddress() + " with request class " + request.getClass(), new Object[0]);
    }

    @Override
    public void onChange(String event, Settings settings) {
        this.settings = settings;
        this.enabled = settings.getAsBoolean("searchguard.dynamic.http.xff.enabled", Boolean.valueOf(true));
        if (this.enabled) {
            this.detector = new RemoteIpDetector();
            this.detector.setInternalProxies(settings.get("searchguard.dynamic.http.xff.internalProxies", this.detector.getInternalProxies()));
            this.detector.setProxiesHeader(settings.get("searchguard.dynamic.http.xff.proxiesHeader", this.detector.getProxiesHeader()));
            this.detector.setRemoteIpHeader(settings.get("searchguard.dynamic.http.xff.remoteIpHeader", this.detector.getRemoteIpHeader()));
            this.detector.setTrustedProxies(settings.get("searchguard.dynamic.http.xff.trustedProxies", this.detector.getTrustedProxies()));
        } else {
            this.detector = null;
        }
    }

    @Override
    public void validate(String event, Settings settings) throws ElasticsearchSecurityException {
    }

    @Override
    public boolean isInitialized() {
        return this.settings != null;
    }
}

