/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.filter;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.support.HeaderHelper;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class SearchGuardRestFilter
extends RestFilter {
    private final BackendRegistry registry;
    private final AuditLog auditLog;

    public SearchGuardRestFilter(BackendRegistry registry, AuditLog auditLog) {
        this.registry = registry;
        this.auditLog = auditLog;
    }

    public void process(RestRequest request, RestChannel channel, RestFilterChain filterChain) throws Exception {
        try {
            HeaderHelper.checkSGHeader(request);
        }
        catch (Exception e) {
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Throwable)e));
            return;
        }
        if (request.method() != RestRequest.Method.OPTIONS && !this.registry.authenticate(request, channel)) {
            return;
        }
        filterChain.continueProcessing(request, channel);
    }
}

