/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginClient;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.kibana.DocumentBuilder;
import io.fabric8.elasticsearch.plugin.kibana.IndexMappingLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.transport.RemoteTransportException;

public class KibanaSeed
implements ConfigurationSettings {
    private static final String DEFAULT_INDEX_TYPE = "config";
    private static final String INDICIES_TYPE = "index-pattern";
    private static final String OPERATIONS_PROJECT = ".operations";
    private static final String BLANK_PROJECT = ".empty-project";
    private static final String ADMIN_ALIAS_NAME = ".all";
    private static final ESLogger LOGGER = Loggers.getLogger(KibanaSeed.class);
    public static final String DEFAULT_INDEX_FIELD = "defaultIndex";
    private final IndexMappingLoader mappingLoader;
    private final PluginClient pluginClient;
    private final String defaultKibanaIndex;
    private final PluginSettings settings;

    @Inject
    public KibanaSeed(PluginSettings settings, IndexMappingLoader loader, PluginClient pluginClient) {
        this.mappingLoader = loader;
        this.pluginClient = pluginClient;
        this.defaultKibanaIndex = settings.getDefaultKibanaIndex();
        this.settings = settings;
    }

    public void setDashboards(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client client, String kibanaVersion, String projectPrefix) {
        if (!this.pluginClient.indexExists(this.defaultKibanaIndex)) {
            LOGGER.debug("Default Kibana index '{}' does not exist. Skipping Kibana seeding", new Object[]{this.defaultKibanaIndex});
            return;
        }
        LOGGER.debug("Begin setDashboards:  projectPrefix '{}' for user '{}' projects '{}' kibanaIndex '{}'", new Object[]{projectPrefix, context.getUser(), context.getProjects(), context.getKibanaIndex()});
        boolean changed = this.initialSeedKibanaIndex(context, client);
        changed = context.isOperationsUser() ? this.seedOperationsIndexPatterns(context, client, kibanaVersion, projectPrefix) : this.seedUsersIndexPatterns(context, client, kibanaVersion, projectPrefix);
        if (changed) {
            this.pluginClient.refreshIndices(context.getKibanaIndex());
        }
    }

    private boolean seedOperationsIndexPatterns(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client client, String kibanaVersion, String projectPrefix) {
        boolean changed = false;
        boolean defaultSet = false;
        for (String pattern : this.settings.getKibanaOpsIndexPatterns()) {
            if (this.pluginClient.documentExists(context.getKibanaIndex(), INDICIES_TYPE, pattern)) continue;
            LOGGER.trace("Creating index-pattern '{}'", new Object[]{pattern});
            String source = StringUtils.replace((String)this.mappingLoader.getOperationsMappingsTemplate(), (String)"$TITLE$", (String)pattern);
            this.pluginClient.createDocument(context.getKibanaIndex(), INDICIES_TYPE, pattern, source);
            if (!defaultSet) {
                try {
                    String update = XContentFactory.jsonBuilder().startObject().field(DEFAULT_INDEX_FIELD, pattern).endObject().string();
                    this.pluginClient.update(context.getKibanaIndex(), DEFAULT_INDEX_TYPE, kibanaVersion, update);
                    defaultSet = true;
                }
                catch (IOException e) {
                    LOGGER.error("Unable to set default index-pattern", (Throwable)e, new Object[0]);
                }
            }
            changed = true;
        }
        return changed;
    }

    private boolean seedUsersIndexPatterns(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client client, String kibanaVersion, String projectPrefix) {
        boolean changed = false;
        Set<String> indexPatterns = this.getProjectNamesFromIndexes(context, client, projectPrefix);
        LOGGER.debug("Found '{}' Index patterns for user", new Object[]{indexPatterns.size()});
        HashSet<String> projects = new HashSet<String>(context.getProjects());
        ArrayList<String> filteredProjects = new ArrayList<String>(this.filterProjectsWithIndices(projectPrefix, projects));
        LOGGER.debug("projects for '{}' that have existing indexes: '{}'", new Object[]{context.getUser(), filteredProjects});
        if (filteredProjects.isEmpty()) {
            filteredProjects.add(BLANK_PROJECT);
        }
        Collections.sort(filteredProjects);
        if (indexPatterns.isEmpty()) {
            this.create(context.getKibanaIndex(), filteredProjects, true, client, kibanaVersion, projectPrefix, indexPatterns);
            changed = true;
        } else {
            ArrayList<String> common = new ArrayList<String>(indexPatterns);
            common.retainAll(filteredProjects);
            filteredProjects.removeAll(common);
            indexPatterns.removeAll(common);
            if (!context.isOperationsUser()) {
                LOGGER.debug("user is not a cluster admin, ensure they don't keep/have the admin alias pattern", new Object[0]);
                indexPatterns.add(ADMIN_ALIAS_NAME);
            }
            if (!filteredProjects.isEmpty() || !indexPatterns.isEmpty()) {
                changed = true;
            }
            this.create(context.getKibanaIndex(), filteredProjects, false, client, kibanaVersion, projectPrefix, indexPatterns);
            this.remove(context.getKibanaIndex(), indexPatterns, client, projectPrefix);
            common.addAll(filteredProjects);
            Collections.sort(common);
            String defaultIndex = this.getDefaultIndex(context, client, kibanaVersion, projectPrefix);
            LOGGER.debug("Checking if index patterns '{}' contain default index '{}'", new Object[]{indexPatterns, defaultIndex});
            if (indexPatterns.contains(defaultIndex) || StringUtils.isEmpty((String)defaultIndex)) {
                LOGGER.debug("'{}' does contain '{}' and common size is {}", new Object[]{indexPatterns, defaultIndex, common.size()});
                if (!common.isEmpty()) {
                    this.setDefaultIndex(context.getKibanaIndex(), (String)common.get(0), client, kibanaVersion, projectPrefix);
                }
            }
        }
        return changed;
    }

    private List<String> filterProjectsWithIndices(String projectPrefix, Set<String> projects) {
        ArrayList<String> result = new ArrayList<String>(projects.size());
        for (String project : projects) {
            String index = this.getIndexPattern(project, projectPrefix);
            if (!this.pluginClient.indexExists(index)) continue;
            result.add(project);
        }
        return result;
    }

    private boolean initialSeedKibanaIndex(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client esClient) {
        try {
            String userIndex = context.getKibanaIndex();
            boolean kibanaIndexExists = this.pluginClient.indexExists(userIndex);
            LOGGER.debug("Kibana index '{}' exists? {}", new Object[]{userIndex, kibanaIndexExists});
            if (!kibanaIndexExists && !this.defaultKibanaIndex.equals(userIndex)) {
                LOGGER.debug("Copying '{}' to '{}'", new Object[]{this.defaultKibanaIndex, userIndex});
                this.pluginClient.copyIndex(this.defaultKibanaIndex, userIndex, DEFAULT_INDEX_TYPE);
                return true;
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOGGER.error("Unable to create initial Kibana index", (Throwable)e, new Object[0]);
        }
        return false;
    }

    private void setDefaultIndex(String kibanaIndex, String project, Client esClient, String kibanaVersion, String projectPrefix) {
        String source = new DocumentBuilder().defaultIndex(this.getIndexPattern(project, projectPrefix)).build();
        this.pluginClient.update(kibanaIndex, DEFAULT_INDEX_TYPE, kibanaVersion, source);
    }

    private String getDefaultIndex(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client esClient, String kibanaVersion, String projectPrefix) {
        GetRequest request = (GetRequest)((GetRequestBuilder)esClient.prepareGet(context.getKibanaIndex(), DEFAULT_INDEX_TYPE, kibanaVersion).putHeader("_sg_conf_request", (Object)"true")).request();
        try {
            GetResponse response = (GetResponse)esClient.get(request).get();
            Map source = response.getSource();
            if (source != null && source.containsKey(DEFAULT_INDEX_FIELD)) {
                LOGGER.debug("Received response with 'defaultIndex' = {}", new Object[]{source.get(DEFAULT_INDEX_FIELD)});
                String index = (String)source.get(DEFAULT_INDEX_FIELD);
                return this.getProjectFromIndex(index, projectPrefix);
            }
            LOGGER.debug("Received response without 'defaultIndex'", new Object[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof RemoteTransportException && e.getCause().getCause() instanceof IndexNotFoundException) {
                LOGGER.debug("No index found", new Object[0]);
            }
            LOGGER.error("Error getting default index for {}", (Throwable)e, new Object[]{context.getUser()});
        }
        return "";
    }

    private void create(String kibanaIndex, List<String> projects, boolean setDefault, Client esClient, String kibanaVersion, String projectPrefix, Set<String> indexPatterns) {
        boolean defaultSet = !setDefault;
        LOGGER.trace("Creating index-patterns for projects: '{}'", new Object[]{projects});
        for (String project : projects) {
            if (indexPatterns.contains(project)) {
                LOGGER.trace("Skipping creation of index-pattern for project '{}'. It already exists.", new Object[]{project});
                continue;
            }
            this.createIndexPattern(kibanaIndex, project, esClient, projectPrefix);
            if (defaultSet) continue;
            this.setDefaultIndex(kibanaIndex, project, esClient, kibanaVersion, projectPrefix);
            defaultSet = true;
        }
    }

    private void remove(String kibanaIndex, Set<String> projects, Client esClient, String projectPrefix) {
        for (String project : projects) {
            this.deleteIndex(kibanaIndex, project, esClient, projectPrefix);
        }
    }

    private Set<String> getProjectNamesFromIndexes(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client esClient, String projectPrefix) {
        HashSet<String> patterns = new HashSet<String>();
        SearchRequest request = ((SearchRequestBuilder)esClient.prepareSearch(new String[]{context.getKibanaIndex()}).setTypes(new String[]{INDICIES_TYPE}).putHeader("_sg_conf_request", (Object)"true")).request();
        try {
            SearchResponse response = (SearchResponse)esClient.search(request).get();
            if (response.getHits() != null && response.getHits().getTotalHits() > 0L) {
                for (SearchHit hit : response.getHits().getHits()) {
                    String id = hit.getId();
                    String project = this.getProjectFromIndex(id, projectPrefix);
                    if (project.equals(id) && !project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) continue;
                    patterns.add(project);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof RemoteTransportException && e.getCause().getCause() instanceof IndexNotFoundException) {
                LOGGER.debug("Encountered IndexMissingException, returning empty response", new Object[0]);
            }
            LOGGER.error("Error getting index patterns for {}", (Throwable)e, new Object[]{context.getUser()});
        }
        return patterns;
    }

    private void createIndexPattern(String kibanaIndex, String project, Client esClient, String projectPrefix) {
        String indexPattern = this.getIndexPattern(project, projectPrefix);
        String source = project.equalsIgnoreCase(BLANK_PROJECT) ? this.mappingLoader.getEmptyProjectMappingsTemplate() : this.mappingLoader.getApplicationMappingsTemplate();
        if (source != null) {
            LOGGER.trace("Creating index-pattern for project '{}'", new Object[]{project});
            source = source.replaceAll("$TITLE$", indexPattern);
            this.pluginClient.createDocument(kibanaIndex, INDICIES_TYPE, indexPattern, source);
        } else {
            LOGGER.debug("The source for the index mapping is null.  Skipping trying to create index pattern {}", new Object[]{indexPattern});
        }
    }

    private void deleteIndex(String kibanaIndex, String project, Client esClient, String projectPrefix) {
        this.executeDelete(kibanaIndex, INDICIES_TYPE, this.getIndexPattern(project, projectPrefix), esClient);
    }

    private void executeDelete(String index, String type, String id, Client esClient) {
        LOGGER.debug("DELETE: '{}/{}/{}'", new Object[]{index, type, id});
        DeleteRequest request = (DeleteRequest)esClient.prepareDelete(index, type, id).request();
        request.putHeader("_sg_conf_request", (Object)"true");
        try {
            esClient.delete(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error executing delete request", (Throwable)e, new Object[0]);
        }
    }

    private String getIndexPattern(String project, String projectPrefix) {
        if (project.startsWith(ADMIN_ALIAS_NAME)) {
            return project;
        }
        if (project.equalsIgnoreCase(OPERATIONS_PROJECT) || StringUtils.isEmpty((String)projectPrefix)) {
            return project + ".*";
        }
        if (project.equalsIgnoreCase(BLANK_PROJECT)) {
            return projectPrefix + project + ".*";
        }
        return projectPrefix + "." + project + ".*";
    }

    private String getProjectFromIndex(String index, String projectPrefix) {
        if (!StringUtils.isEmpty((String)index)) {
            if (index.startsWith(ADMIN_ALIAS_NAME)) {
                return index;
            }
            int wildcard = index.lastIndexOf(46);
            if (wildcard > 0) {
                int start = 0;
                String projectPrefixTest = projectPrefix;
                if (StringUtils.isNotEmpty((String)projectPrefix)) {
                    projectPrefixTest = projectPrefix + ".";
                }
                if (index.startsWith(projectPrefixTest)) {
                    start = projectPrefixTest.length();
                }
                if (wildcard > start) {
                    return index.substring(start, wildcard);
                }
            }
        }
        return index;
    }
}

