/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.acl.RoleBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class SearchGuardRoles
implements Iterable<Roles>,
ConfigurationSettings,
SearchGuardACLDocument {
    public static final String ROLE_PREFIX = "gen";
    public static final String PROJECT_PREFIX = "gen_project";
    public static final String USER_PREFIX = "gen_user";
    private static final String CLUSTER_HEADER = "cluster";
    private static final String INDICES_HEADER = "indices";
    private List<Roles> roles = new ArrayList<Roles>();

    @Override
    public Iterator<Roles> iterator() {
        return new ArrayList<Roles>(this.roles).iterator();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void removeRole(Roles role) {
        this.roles.remove(role);
    }

    public void addAll(Collection<Roles> roles) {
        this.roles.addAll(roles);
    }

    public static String formatUniqueKibanaRoleName(String username) {
        return String.format("%s_%s_%s", ROLE_PREFIX, "kibana", KibanaUserReindexFilter.getUsernameHash(username));
    }

    public SearchGuardRoles load(Map<String, Object> source) {
        RolesBuilder builder = new RolesBuilder();
        for (String key : source.keySet()) {
            RoleBuilder roleBuilder = new RoleBuilder(key);
            HashMap role = (HashMap)source.get(key);
            if (role.containsKey(CLUSTER_HEADER)) {
                ArrayList cluster = (ArrayList)role.get(CLUSTER_HEADER);
                roleBuilder.setClusters(cluster);
            }
            if (role.containsKey(INDICES_HEADER)) {
                HashMap indices = (HashMap)role.get(INDICES_HEADER);
                for (String index : indices.keySet()) {
                    for (String type : ((HashMap)indices.get(index)).keySet()) {
                        List actions = (List)((HashMap)indices.get(index)).get(type);
                        roleBuilder.setActions(index, type, actions);
                    }
                }
            }
            builder.addRole(roleBuilder.build());
        }
        this.roles = builder.build();
        return this;
    }

    public Map<String, Object> toMap() {
        TreeMap<String, Object> output = new TreeMap<String, Object>();
        for (Roles role : this.roles) {
            TreeMap<String, Object> roleObject = new TreeMap<String, Object>();
            TreeMap indexObject = new TreeMap();
            for (Roles.Indices index : role.getIndices()) {
                TreeMap<String, List<String>> typeObject = new TreeMap<String, List<String>>();
                for (Roles.Indices.Type type : index.getTypes()) {
                    typeObject.put(type.getType(), type.getActions());
                }
                indexObject.put(index.getIndex(), typeObject);
            }
            if (!indexObject.isEmpty()) {
                roleObject.put(INDICES_HEADER, indexObject);
            }
            if (!role.getCluster().isEmpty()) {
                roleObject.put(CLUSTER_HEADER, role.getCluster());
            }
            output.put(role.getName(), roleObject);
        }
        return output;
    }

    @Override
    public String getType() {
        return "roles";
    }

    @Override
    public XContentBuilder toXContentBuilder() {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.map(this.toMap());
            return builder;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert the SearchGuardRoles to JSON", e);
        }
    }

    public static class Roles {
        private String name;
        private List<String> cluster;
        private List<Indices> indices;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getCluster() {
            return this.cluster;
        }

        public void setCluster(List<String> cluster) {
            this.cluster = cluster;
        }

        public List<Indices> getIndices() {
            return this.indices;
        }

        public void setIndices(List<Indices> indices) {
            this.indices = indices;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public static class Indices {
            private String index;
            private List<Type> types;

            public String getIndex() {
                return this.index;
            }

            public void setIndex(String index) {
                this.index = index;
            }

            public List<Type> getTypes() {
                return this.types;
            }

            public void setTypes(List<Type> types) {
                this.types = types;
            }

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            }

            public static class Type {
                private String type;
                private List<String> actions;

                public String getType() {
                    return this.type;
                }

                public void setType(String type) {
                    this.type = type;
                }

                public List<String> getActions() {
                    return this.actions;
                }

                public void setActions(List<String> actions) {
                    this.actions = actions;
                }

                public String toString() {
                    return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
                }
            }
        }
    }
}

