/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.BaseRolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;

public class ProjectRolesMappingSyncStrategy
extends BaseRolesMappingSyncStrategy {
    public ProjectRolesMappingSyncStrategy(SearchGuardRolesMapping rolesMapping) {
        super(rolesMapping);
    }

    @Override
    protected void syncFromImpl(UserProjectCache cache, RolesMappingBuilder builder) {
        for (Map.Entry<AbstractMap.SimpleImmutableEntry<String, String>, Set<String>> userProjects : cache.getUserProjects().entrySet()) {
            String username = userProjects.getKey().getKey();
            String token = userProjects.getKey().getValue();
            for (String project : userProjects.getValue()) {
                String projectRoleName = String.format("%s_%s", "gen_project", project.replace('.', '_'));
                builder.addUser(projectRoleName, username);
            }
            if (cache.isOperationsUser(username, token)) {
                builder.addUser("gen_project_operations", username);
                builder.addUser("gen_ocp_kibana_shared", username);
                continue;
            }
            String kibanaRoleName = SearchGuardRoles.formatUniqueKibanaRoleName(username);
            builder.addUser(kibanaRoleName, username);
        }
    }
}

