/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class PluginSettings
implements ConfigurationSettings {
    private static final ESLogger LOGGER = Loggers.getLogger(PluginSettings.class);
    private String kibanaIndexMode;
    private String roleStrategy;
    private final String cdmProjectPrefix;
    private final String defaultKibanaIndex;
    private final String searchGuardIndex;
    private final String kibanaVersion;
    private final String kbnVersionHeader;
    private final Boolean enabled;
    private final Set<String> opsIndexPatterns;

    @Inject
    public PluginSettings(Settings settings) {
        this.kibanaIndexMode = settings.get("openshift.kibana.index.mode", "unique");
        if (!ArrayUtils.contains((Object[])new String[]{"unique", "shared_ops", "shared_non_ops"}, (Object)this.kibanaIndexMode.toLowerCase())) {
            this.kibanaIndexMode = "unique";
        }
        this.roleStrategy = settings.get("openshift.acl.role_strategy", "user");
        if (!ArrayUtils.contains((Object[])new String[]{"project", "user"}, (Object)this.roleStrategy.toLowerCase())) {
            this.kibanaIndexMode = "user";
        }
        this.cdmProjectPrefix = settings.get("openshift.config.project_index_prefix", "");
        this.defaultKibanaIndex = settings.get("kibana.config_index_name", ".kibana");
        this.searchGuardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.kibanaVersion = settings.get("kibana.version", "4.5.1");
        this.kbnVersionHeader = settings.get("kibana.version.header", "kbn-version");
        this.enabled = settings.getAsBoolean("openshift.acl.dynamic.enabled", Boolean.valueOf(true));
        this.opsIndexPatterns = new HashSet<String>(Arrays.asList(settings.getAsArray("openshift.kibana.ops_index_patterns", DEFAULT_KIBANA_OPS_INDEX_PATTERNS)));
        LOGGER.info("Using kibanaIndexMode: '{}'", new Object[]{this.kibanaIndexMode});
        LOGGER.debug("searchGuardIndex: {}", new Object[]{this.searchGuardIndex});
        LOGGER.debug("roleStrategy: {}", new Object[]{this.roleStrategy});
    }

    public String getRoleStrategy() {
        return this.roleStrategy;
    }

    public String getKibanaIndexMode() {
        return this.kibanaIndexMode;
    }

    public String getCdmProjectPrefix() {
        return this.cdmProjectPrefix;
    }

    public String getDefaultKibanaIndex() {
        return this.defaultKibanaIndex;
    }

    public String getSearchGuardIndex() {
        return this.searchGuardIndex;
    }

    public String getKibanaVersion() {
        return this.kibanaVersion;
    }

    public String getKbnVersionHeader() {
        return this.kbnVersionHeader;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setKibanaIndexMode(String kibanaIndexMode) {
        this.kibanaIndexMode = kibanaIndexMode;
    }

    public Set<String> getKibanaOpsIndexPatterns() {
        return this.opsIndexPatterns;
    }
}

