/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.util;

import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class RequestUtils
implements ConfigurationSettings {
    private static final ESLogger LOGGER = Loggers.getLogger(RequestUtils.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private String proxyUserHeader;

    @Inject
    public RequestUtils(Settings settings) {
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
    }

    public String getUser(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.proxyUserHeader), (Object)"");
    }

    public String getBearerToken(RestRequest request) {
        String[] auth = ((String)ObjectUtils.defaultIfNull((Object)request.header(AUTHORIZATION_HEADER), (Object)"")).split(" ");
        if (auth.length >= 2 && "Bearer".equals(auth[0])) {
            return auth[1];
        }
        return "";
    }

    public boolean isClientCertAuth(RestRequest request) {
        return request != null && request.hasInContext((Object)"_sg_ssl_principal") && StringUtils.isNotEmpty((String)((String)request.getFromContext((Object)"_sg_ssl_principal", (Object)"")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOperationsUser(RestRequest request) {
        String user = this.getUser(request);
        String token = this.getBearerToken(request);
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        boolean allowed = false;
        try (DefaultOpenShiftClient osClient = new DefaultOpenShiftClient(builder.build());){
            LOGGER.debug("Submitting a SAR to see if '{}' is able to retrieve logs across the cluster", new Object[]{user});
            SubjectAccessReviewResponse response = (SubjectAccessReviewResponse)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((NamespacedOpenShiftClient)osClient.inAnyNamespace()).subjectAccessReviews().createNew()).withVerb("get")).withResource("pods/log")).done();
            allowed = response.getAllowed();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Exception determining user's '{}' role.", (Throwable)e, new Object[]{user});
            }
            catch (Throwable throwable) {
                LOGGER.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
                throw throwable;
            }
            LOGGER.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
        }
        LOGGER.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
        return allowed;
    }

    public String assertUser(RestRequest request) throws Exception {
        String username = null;
        String user = this.getUser(request);
        String token = this.getBearerToken(request);
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        try (DefaultOpenShiftClient osClient = new DefaultOpenShiftClient(builder.build());){
            LOGGER.debug("Verifying user {} matches the given token.", new Object[]{user});
            Request okRequest = new Request.Builder().addHeader(AUTHORIZATION_HEADER, "Bearer " + token).url(osClient.getMasterUrl() + "oapi/v1/users/~").build();
            Response response = null;
            try {
                response = osClient.getHttpClient().newCall(okRequest).execute();
                String body = response.body().string();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Response: code '{}' {}", new Object[]{response.code(), body});
                }
                if (response.code() != RestStatus.OK.getStatus()) {
                    throw new ElasticsearchSecurityException("Could not authenticate with given token", RestStatus.UNAUTHORIZED, new Object[0]);
                }
                Map userResponse = (Map)XContentHelper.convertToMap((BytesReference)new BytesArray(body), (boolean)false).v2();
                if (userResponse.containsKey("metadata") && ((Map)userResponse.get("metadata")).containsKey("name")) {
                    username = (String)((Map)userResponse.get("metadata")).get("name");
                }
            }
            catch (Exception e) {
                LOGGER.debug("Exception trying to assertUser '{}'", (Throwable)e, new Object[]{user});
                throw e;
            }
            if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank((String)user) && !user.equals(username)) {
                String message = String.format("The given username '%s' does not match the username '%s' associated with the token provided with the request.", user, username);
                LOGGER.debug(message, new Object[0]);
            }
        }
        if (null == username) {
            throw new ElasticsearchSecurityException("Could not determine username from token", RestStatus.UNAUTHORIZED, new Object[0]);
        }
        return username;
    }

    public void setUser(RestRequest request, String user) {
        LOGGER.debug("Modifying header '{}' to be '{}'", new Object[]{this.proxyUserHeader, user});
        request.putHeader(this.proxyUserHeader, (Object)user);
    }

    public RestRequest modifyRequest(RestRequest request, OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        if (!this.getUser(request).equals(context.getUser()) && request instanceof NettyHttpRequest) {
            NettyHttpRequest netty = (NettyHttpRequest)request;
            HttpRequest httpRequest = netty.request();
            httpRequest.headers().set(this.proxyUserHeader, (Object)context.getUser());
            return new NettyHttpRequest(httpRequest, netty.getChannel());
        }
        return request;
    }
}

