/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class PluginClient {
    private static ESLogger LOGGER = Loggers.getLogger(PluginClient.class);
    private final Client client;

    @Inject
    public PluginClient(Client client) {
        this.client = client;
    }

    public UpdateResponse update(String index, String type, String id, String source) {
        LOGGER.debug("UPDATE: '{}/{}/{}' source: '{}'", new Object[]{index, type, id, source});
        UpdateRequestBuilder builder = this.client.prepareUpdate(index, type, id).setDoc(source).setDocAsUpsert(true);
        this.addCommonHeaders((ActionRequestBuilder)builder);
        UpdateResponse response = (UpdateResponse)builder.get();
        LOGGER.debug("Created with update? '{}'", new Object[]{response.isCreated()});
        return response;
    }

    public IndexResponse createDocument(String index, String type, String id, String source) {
        LOGGER.trace("create document: '{}/{}/{}' source: '{}'", new Object[]{index, type, id, source});
        IndexRequestBuilder builder = this.client.prepareIndex(index, type, id).setSource(source);
        this.addCommonHeaders((ActionRequestBuilder)builder);
        IndexResponse response = (IndexResponse)builder.get();
        return response;
    }

    public GetIndexResponse getIndices(String ... indices) throws InterruptedException, ExecutionException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Getting indices '{}'", new Object[]{StringUtils.join((Object[])indices, (String)", ")});
        }
        GetIndexRequestBuilder builder = (GetIndexRequestBuilder)this.client.admin().indices().prepareGetIndex().setIndices(indices);
        this.addCommonHeaders((ActionRequestBuilder)builder);
        return (GetIndexResponse)builder.get();
    }

    public CreateIndexResponse copyIndex(String source, String target, String ... types) throws InterruptedException, ExecutionException, IOException {
        LOGGER.trace("Copying {} index to {} for types {}", new Object[]{source, target, types});
        GetIndexResponse response = this.getIndices(source);
        CreateIndexRequestBuilder builder = this.client.admin().indices().prepareCreate(target).setSettings((Settings)response.getSettings().get((Object)source));
        for (String type : types) {
            builder.addMapping(type, ((MappingMetaData)((ImmutableOpenMap)response.mappings().get((Object)source)).get((Object)type)).getSourceAsMap());
        }
        this.addCommonHeaders((ActionRequestBuilder)builder);
        return (CreateIndexResponse)builder.get();
    }

    public RefreshResponse refreshIndices(String ... indices) {
        RefreshRequestBuilder builder = this.client.admin().indices().prepareRefresh(indices);
        this.addCommonHeaders((ActionRequestBuilder)builder);
        RefreshResponse response = (RefreshResponse)builder.get();
        LOGGER.debug("Refreshed '{}' successfully on {} of {} shards", new Object[]{indices, response.getSuccessfulShards(), response.getTotalShards()});
        return response;
    }

    public boolean indexExists(String index) {
        LOGGER.trace("Checking for existance of index '{}'", new Object[]{index});
        IndicesExistsRequestBuilder builder = this.client.admin().indices().prepareExists(new String[]{index});
        this.addCommonHeaders((ActionRequestBuilder)builder);
        IndicesExistsResponse response = (IndicesExistsResponse)builder.get();
        boolean exists = response.isExists();
        LOGGER.trace("Index '{}' exists? {}", new Object[]{index, exists});
        return exists;
    }

    public boolean documentExists(String index, String type, String id) {
        LOGGER.trace("Checking for existence of document: '{}/{}/{}'", new Object[]{index, type, id});
        GetRequestBuilder builder = ((GetRequestBuilder)this.client.prepareGet().setIndex(index)).setType(type).setId(id).setFields(new String[0]);
        this.addCommonHeaders((ActionRequestBuilder)builder);
        GetResponse response = (GetResponse)builder.get();
        boolean exists = response.isExists();
        LOGGER.trace("Document '{}/{}/{}' exists? {}", new Object[]{index, type, id, exists});
        return exists;
    }

    public Set<String> getIndicesForAlias(String alias) {
        LOGGER.trace("Retrieving indices for alias '{}'", new Object[]{alias});
        GetAliasesRequestBuilder builder = this.client.admin().indices().prepareGetAliases(new String[]{alias});
        this.addCommonHeaders((ActionRequestBuilder)builder);
        GetAliasesResponse response = (GetAliasesResponse)builder.get();
        UnmodifiableIterator keysIt = response.getAliases().keysIt();
        HashSet<String> indices = new HashSet<String>();
        while (keysIt.hasNext()) {
            indices.add((String)keysIt.next());
        }
        LOGGER.trace("Indices for alias '{}': {}", new Object[]{alias, indices});
        return indices;
    }

    public boolean alias(Map<String, String> aliases) {
        boolean acknowledged = false;
        if (aliases.isEmpty()) {
            LOGGER.trace("The alias map is empty.  Nothing to do", new Object[0]);
            return acknowledged;
        }
        IndicesAliasesRequestBuilder builder = this.client.admin().indices().prepareAliases();
        this.addCommonHeaders((ActionRequestBuilder)builder);
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            LOGGER.debug("Creating alias for {} as {}", new Object[]{entry.getKey(), entry.getValue()});
            builder.addAlias(entry.getKey(), entry.getValue());
        }
        IndicesAliasesResponse response = (IndicesAliasesResponse)builder.get();
        acknowledged = response.isAcknowledged();
        LOGGER.debug("Aliases request acknowledged? {}", new Object[]{acknowledged});
        return acknowledged;
    }

    private void addCommonHeaders(ActionRequestBuilder builder) {
        builder.putHeader("_sg_conf_request", (Object)"true");
    }
}

