/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.OpenshiftClientFactory;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.fabric8.elasticsearch.util.RequestUtils;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;

public class OpenshiftRequestContextFactory {
    private static final ESLogger LOGGER = Loggers.getLogger(OpenshiftRequestContextFactory.class);
    private final OpenshiftClientFactory clientFactory;
    private final RequestUtils utils;
    private final String[] operationsProjects;
    private final String kibanaPrefix;
    private String kibanaIndexMode;

    @Inject
    public OpenshiftRequestContextFactory(Settings settings, RequestUtils utils, OpenshiftClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.utils = utils;
        this.operationsProjects = settings.getAsArray("openshift.operations.project.names", ConfigurationSettings.DEFAULT_OPENSHIFT_OPS_PROJECTS);
        this.kibanaPrefix = settings.get("kibana.config_index_name", ".kibana");
        this.kibanaIndexMode = settings.get("openshift.kibana.index.mode", "unique");
        if (!ArrayUtils.contains((Object[])new String[]{"unique", "shared_ops", "shared_non_ops"}, (Object)this.kibanaIndexMode.toLowerCase())) {
            this.kibanaIndexMode = "unique";
        }
        LOGGER.info("Using kibanaIndexMode: '{}'", new Object[]{this.kibanaIndexMode});
    }

    public OpenshiftRequestContext create(RestRequest request, UserProjectCache cache) throws Exception {
        this.logRequest(request, cache);
        HashSet<String> projects = new HashSet();
        boolean isClusterAdmin = false;
        String user = this.utils.getUser(request);
        String token = this.utils.getBearerToken(request);
        if (StringUtils.isNotBlank((String)token)) {
            user = this.utils.assertUser(request);
            isClusterAdmin = this.utils.isOperationsUser(request);
            projects = this.listProjectsFor(user, token);
            if (user.contains("\\")) {
                user = user.replace("\\", "/");
            }
            this.utils.setUser(request, user);
            return new OpenshiftRequestContext(user, token, isClusterAdmin, projects, this.getKibanaIndex(user, isClusterAdmin), this.kibanaIndexMode);
        }
        if (StringUtils.isNotBlank((String)user)) {
            LOGGER.debug("Received a request with a user but no token. Setting userheader to empty.", new Object[0]);
            this.utils.setUser(request, "");
        }
        LOGGER.debug("Returing EMPTY request context; either was provided client cert or empty token.", new Object[0]);
        return OpenshiftRequestContext.EMPTY;
    }

    private void logRequest(RestRequest request, UserProjectCache cache) {
        if (LOGGER.isDebugEnabled()) {
            String user = this.utils.getUser(request);
            String token = this.utils.getBearerToken(request);
            LOGGER.debug("Handling Request... {}", new Object[]{request.uri()});
            if (LOGGER.isTraceEnabled()) {
                ArrayList<String> headers = new ArrayList<String>();
                for (Map.Entry entry : request.headers()) {
                    if ("Authorization".equals(entry.getKey())) {
                        headers.add((String)entry.getKey() + "=Bearer <REDACTED>");
                        continue;
                    }
                    headers.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
                LOGGER.trace("Request headers: {}", new Object[]{request.headers()});
                LOGGER.trace("Request context: {}", new Object[]{request.getContext()});
            }
            LOGGER.debug("Evaluating request for user '{}' with a {} token", new Object[]{user, StringUtils.isNotEmpty((String)token) ? "non-empty" : "empty"});
            LOGGER.debug("Cache has user: {}", new Object[]{cache.hasUser(user, token)});
        }
    }

    private Set<String> listProjectsFor(String user, String token) throws Exception {
        HashSet<String> names = new HashSet<String>();
        try {
            ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
            try (OpenShiftClient client = this.clientFactory.create(builder.build());){
                List projects = ((ProjectList)client.projects().list()).getItems();
                for (Project project : projects) {
                    if (this.isBlacklistProject(project.getMetadata().getName())) continue;
                    names.add(project.getMetadata().getName() + "." + project.getMetadata().getUid());
                }
            }
        }
        catch (KubernetesClientException e) {
            LOGGER.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
            throw new ElasticsearchSecurityException(e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
        }
        return names;
    }

    private boolean isBlacklistProject(String project) {
        return ArrayUtils.contains((Object[])this.operationsProjects, (Object)project.toLowerCase());
    }

    private String getKibanaIndex(String username, boolean isOpsUser) {
        return OpenshiftRequestContextFactory.getKibanaIndex(this.kibanaPrefix, this.kibanaIndexMode, username, isOpsUser);
    }

    public static String getKibanaIndex(String kibanaPrefix, String kibanaIndexMode, String username, boolean isOpsUser) {
        if (StringUtils.isBlank((String)username)) {
            return "";
        }
        if (("shared_ops".equals(kibanaIndexMode) || "shared_non_ops".equals(kibanaIndexMode)) && isOpsUser) {
            return kibanaPrefix;
        }
        if ("shared_non_ops".equals(kibanaIndexMode)) {
            return kibanaPrefix + "_non_ops";
        }
        return kibanaPrefix + "." + KibanaUserReindexFilter.getUsernameHash(username);
    }

    public static class OpenshiftRequestContext {
        public static final OpenshiftRequestContext EMPTY = new OpenshiftRequestContext("", "", false, new HashSet<String>(), "", "unique");
        private final String user;
        private final String token;
        private final boolean isClusterAdmin;
        private final Set<String> projects;
        private final String kibanaIndex;
        private final String kibanaIndexMode;

        public OpenshiftRequestContext(String user, String token, boolean isClusterAdmin, Set<String> projects, String kibanaIndex, String kibanaIndexMode) {
            this.user = user;
            this.token = token;
            this.isClusterAdmin = isClusterAdmin;
            this.projects = new HashSet<String>(projects);
            this.kibanaIndex = kibanaIndex;
            this.kibanaIndexMode = kibanaIndexMode;
        }

        public boolean isAuthenticated() {
            return StringUtils.isNotEmpty((String)this.token) && StringUtils.isNotEmpty((String)this.user);
        }

        public String getUser() {
            return this.user;
        }

        public String getToken() {
            return this.token;
        }

        public boolean isOperationsUser() {
            return this.isClusterAdmin;
        }

        public Set<String> getProjects() {
            return this.projects;
        }

        public String getKibanaIndex() {
            return this.kibanaIndex;
        }

        public String getKibanaIndexMode() {
            return this.kibanaIndexMode;
        }
    }
}

