/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;

public class OpenShiftOAuthInterceptor
implements Interceptor {
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOCATION = "Location";
    private static final String AUTHORIZE_PATH = "oauth/authorize?response_type=token&client_id=openshift-challenging-client";
    private static final String BEFORE_TOKEN = "access_token=";
    private static final String AFTER_TOKEN = "&expires";
    private final OkHttpClient client;
    private final OpenShiftConfig config;
    private final AtomicReference<String> oauthToken = new AtomicReference();

    public OpenShiftOAuthInterceptor(OkHttpClient client, OpenShiftConfig config) {
        this.client = client;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        builder.header("Accept", "application/json");
        String token = this.oauthToken.get();
        if (Utils.isNotNullOrEmpty((String)token)) {
            this.setAuthHeader(builder, token);
        }
        if (((response = chain.proceed(request = builder.build())).code() == 401 || response.code() == 403) && Utils.isNotNullOrEmpty((String)this.config.getUsername()) && Utils.isNotNullOrEmpty((String)this.config.getPassword())) {
            response.body().close();
            OkHttpClient okHttpClient = this.client;
            synchronized (okHttpClient) {
                token = this.authorize();
                if (token != null) {
                    this.oauthToken.set(token);
                    this.setAuthHeader(builder, token);
                    request = builder.build();
                    return chain.proceed(request);
                }
            }
        }
        return response;
    }

    private void setAuthHeader(Request.Builder builder, String token) {
        if (token != null) {
            builder.header(AUTHORIZATION, String.format("Bearer %s", token));
        }
    }

    private String authorize() {
        try {
            OkHttpClient clone = this.client.clone();
            clone.interceptors().remove(this);
            String credential = Credentials.basic((String)this.config.getUsername(), (String)new String(this.config.getPassword()));
            URL url = new URL(URLUtils.join((String[])new String[]{this.config.getMasterUrl(), AUTHORIZE_PATH}));
            Response response = clone.newCall(new Request.Builder().get().url(url).header(AUTHORIZATION, credential).build()).execute();
            response.body().close();
            String token = response.priorResponse().networkResponse().header(LOCATION);
            token = token.substring(token.indexOf(BEFORE_TOKEN) + BEFORE_TOKEN.length());
            token = token.substring(0, token.indexOf(AFTER_TOKEN));
            return token;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }
}

