/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReference;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceFluent;
import io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SubresourceReferenceBuilder
extends SubresourceReferenceFluentImpl<SubresourceReferenceBuilder>
implements VisitableBuilder<SubresourceReference, SubresourceReferenceBuilder> {
    SubresourceReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public SubresourceReferenceBuilder() {
        this(true);
    }

    public SubresourceReferenceBuilder(Boolean validationEnabled) {
        this(new SubresourceReference(), validationEnabled);
    }

    public SubresourceReferenceBuilder(SubresourceReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SubresourceReferenceBuilder(SubresourceReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SubresourceReference(), validationEnabled);
    }

    public SubresourceReferenceBuilder(SubresourceReferenceFluent<?> fluent, SubresourceReference instance) {
        this(fluent, instance, true);
    }

    public SubresourceReferenceBuilder(SubresourceReferenceFluent<?> fluent, SubresourceReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withSubresource(instance.getSubresource());
        this.validationEnabled = validationEnabled;
    }

    public SubresourceReferenceBuilder(SubresourceReference instance) {
        this(instance, (Boolean)true);
    }

    public SubresourceReferenceBuilder(SubresourceReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withSubresource(instance.getSubresource());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SubresourceReference build() {
        SubresourceReference buildable = new SubresourceReference(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getSubresource());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubresourceReferenceBuilder that = (SubresourceReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

