/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.filter;

import io.fabric8.elasticsearch.plugin.PluginClient;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldstats.FieldStatsRequest;
import org.elasticsearch.action.fieldstats.FieldStatsResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;

public class FieldStatsResponseFilter
implements ActionFilter {
    public static final String INDICES_FIELD_STATS_READ_ACTION = "indices:data/read/field_stats";
    private static final ESLogger LOGGER = Loggers.getLogger(FieldStatsResponseFilter.class);
    private final PluginClient client;

    @Inject
    public FieldStatsResponseFilter(PluginClient client) {
        this.client = client;
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public void apply(String action, ActionResponse response, ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, response, listener);
    }

    public void apply(Task task, final String action, final ActionRequest request, final ActionListener listener, ActionFilterChain chain) {
        chain.proceed(task, action, request, (ActionListener)new ActionListener<ActionResponse>(){

            public void onResponse(ActionResponse response) {
                if (FieldStatsResponseFilter.INDICES_FIELD_STATS_READ_ACTION.equals(action) && response instanceof FieldStatsResponse && ((FieldStatsResponse)response).getIndicesMergedFieldStats().isEmpty()) {
                    LOGGER.trace("Modifying the response to be {}", new Object[]{RestStatus.NO_CONTENT});
                    ElasticsearchException err = new ElasticsearchException("The index returned an empty result. You can use the Time Picker to change the time filter or select a higher time interval", new Object[]{RestStatus.NO_CONTENT});
                    listener.onFailure((Throwable)err);
                    return;
                }
                listener.onResponse((Object)response);
            }

            public void onFailure(Throwable e) {
                LOGGER.trace("Evaluating failure for action '{}' to see if we need to change from a 403", new Object[]{action});
                Throwable err = e;
                if (FieldStatsResponseFilter.INDICES_FIELD_STATS_READ_ACTION.equals(action) && request instanceof FieldStatsRequest) {
                    for (String index : ((FieldStatsRequest)request).indices()) {
                        if (FieldStatsResponseFilter.this.client.indexExists(index)) continue;
                        LOGGER.trace("Modifying the response to be {}", new Object[]{RestStatus.NOT_FOUND});
                        err = new ElasticsearchException("The index '" + index + "' was not found. This could mean data has not yet been collected.", new Object[]{RestStatus.NOT_FOUND});
                        break;
                    }
                }
                listener.onFailure(err);
            }
        });
    }
}

