/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.BaseRolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RoleBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ProjectRolesSyncStrategy
extends BaseRolesSyncStrategy {
    private final String cdmProjectPrefix;
    private final String kibanaIndexMode;

    public ProjectRolesSyncStrategy(SearchGuardRoles roles, String userProfilePrefix, String cdmProjectPrefix, String kibanaIndexMode) {
        super(roles, userProfilePrefix);
        this.roles = roles;
        this.cdmProjectPrefix = cdmProjectPrefix;
        this.kibanaIndexMode = kibanaIndexMode;
    }

    @Override
    public void syncFromImpl(UserProjectCache cache, RolesBuilder builder) {
        for (String project : cache.getAllProjects()) {
            String projectName = String.format("%s_%s", "gen_project", project.replace('.', '_'));
            String indexName = String.format("%s?*", project.replace('.', '?'));
            RoleBuilder role = new RoleBuilder(projectName).setActions(indexName, "*", PROJECT_ROLE_ACTIONS);
            if (StringUtils.isNotEmpty((String)this.cdmProjectPrefix)) {
                indexName = String.format("%s?%s?*", this.cdmProjectPrefix.replace('.', '?'), project.replace('.', '?'));
                role.setActions(indexName, "*", PROJECT_ROLE_ACTIONS);
            }
            builder.addRole(role.build());
        }
        boolean foundAnOpsUser = false;
        for (Map.Entry<AbstractMap.SimpleImmutableEntry<String, String>, Set<String>> userToProjects : cache.getUserProjects().entrySet()) {
            String username = userToProjects.getKey().getKey();
            String token = userToProjects.getKey().getValue();
            String roleName = this.formatKibanaRoleName(cache, username, token);
            String indexName = this.formatKibanaIndexName(cache, username, token, this.kibanaIndexMode);
            RoleBuilder role = new RoleBuilder(roleName).setActions(indexName, "*", KIBANA_ROLE_INDEX_ACTIONS);
            if (cache.isOperationsUser(username, token)) {
                foundAnOpsUser = true;
                role.setClusters(KIBANA_ROLE_CLUSTER_ACTIONS).setActions("*", "*", KIBANA_ROLE_ALL_INDEX_ACTIONS);
            }
            builder.addRole(role.build());
        }
        if (foundAnOpsUser) {
            RoleBuilder opsRole = new RoleBuilder("gen_project_operations").setClusters(OPERATIONS_ROLE_CLUSTER_ACTIONS).setActions("?operations?", "*", OPERATIONS_ROLE_OPERATIONS_ACTIONS).setActions("*?*?*", "*", OPERATIONS_ROLE_ANY_ACTIONS);
            builder.addRole(opsRole.build());
        }
    }
}

