/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.netty.util.internal.ConcurrentSet;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class UserProjectCacheMapAdapter
implements UserProjectCache {
    private final ESLogger logger;
    private final Map<AbstractMap.SimpleImmutableEntry<String, String>, Set<String>> cache = new ConcurrentHashMap<AbstractMap.SimpleImmutableEntry<String, String>, Set<String>>();
    private final Map<AbstractMap.SimpleImmutableEntry<String, String>, Long> createTimes = new ConcurrentHashMap<AbstractMap.SimpleImmutableEntry<String, String>, Long>();
    private final Map<AbstractMap.SimpleImmutableEntry<String, String>, Boolean> operationsUsers = new ConcurrentHashMap<AbstractMap.SimpleImmutableEntry<String, String>, Boolean>();
    private final Set<String> projects = new ConcurrentSet();
    private static final long EXPIRE = 60000L;

    @Inject
    public UserProjectCacheMapAdapter(Settings settings) {
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
    }

    @Override
    public Map<AbstractMap.SimpleImmutableEntry<String, String>, Set<String>> getUserProjects() {
        return Collections.unmodifiableMap(this.cache);
    }

    @Override
    public boolean hasUser(String user, String token) {
        AbstractMap.SimpleImmutableEntry<String, String> sie = new AbstractMap.SimpleImmutableEntry<String, String>(user, token);
        return this.cache.containsKey(sie);
    }

    @Override
    public boolean isOperationsUser(String user, String token) {
        AbstractMap.SimpleImmutableEntry<String, String> sie = new AbstractMap.SimpleImmutableEntry<String, String>(user, token);
        return this.operationsUsers.containsKey(sie) && this.operationsUsers.get(sie) != false;
    }

    @Override
    public void update(String user, String token, Set<String> projects, boolean operationsUser) {
        AbstractMap.SimpleImmutableEntry<String, String> sie = new AbstractMap.SimpleImmutableEntry<String, String>(user, token);
        this.cache.put(sie, new HashSet<String>(projects));
        this.createTimes.put(sie, System.currentTimeMillis() + 60000L);
        this.operationsUsers.put(sie, operationsUser);
        this.projects.addAll(projects);
    }

    @Override
    public void expire() {
        long now = System.currentTimeMillis();
        for (Map.Entry<AbstractMap.SimpleImmutableEntry<String, String>, Long> entry : new HashSet<Map.Entry<AbstractMap.SimpleImmutableEntry<String, String>, Long>>(this.createTimes.entrySet())) {
            if (now <= entry.getValue()) continue;
            this.logger.debug("Expiring cache entry for {}", new Object[]{entry.getKey()});
            this.cache.remove(entry.getKey());
            this.createTimes.remove(entry.getKey());
            this.operationsUsers.remove(entry.getKey());
        }
    }

    @Override
    public Set<String> getAllProjects() {
        return Collections.unmodifiableSet(this.projects);
    }
}

