/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;

public abstract class BaseRolesSyncStrategy
implements RolesSyncStrategy {
    protected SearchGuardRoles roles;
    private final String userProfilePrefix;

    protected BaseRolesSyncStrategy(SearchGuardRoles roles, String userProfilePrefix) {
        this.roles = roles;
        this.userProfilePrefix = userProfilePrefix;
    }

    protected abstract void syncFromImpl(UserProjectCache var1, RolesBuilder var2);

    @Override
    public void syncFrom(UserProjectCache cache) {
        this.removeSyncAcls();
        RolesBuilder builder = new RolesBuilder();
        this.syncFromImpl(cache, builder);
        this.roles.addAll(builder.build());
    }

    private void removeSyncAcls() {
        for (SearchGuardRoles.Roles role : this.roles) {
            if (role.getName() == null || !role.getName().startsWith("gen")) continue;
            this.roles.removeRole(role);
        }
    }

    protected String formatKibanaIndexName(UserProjectCache cache, String username, String token, String kibanaIndexMode) {
        String kibanaIndex = OpenshiftRequestContextFactory.getKibanaIndex(this.userProfilePrefix, kibanaIndexMode, username, cache.isOperationsUser(username, token));
        return kibanaIndex.replace('.', '?');
    }

    protected String formatKibanaRoleName(UserProjectCache cache, String username, String token) {
        boolean isOperationsUser = cache.isOperationsUser(username, token);
        if (isOperationsUser) {
            return "gen_ocp_kibana_shared";
        }
        return SearchGuardRoles.formatUniqueKibanaRoleName(username);
    }

    public static String formatUserRoleName(String username) {
        return String.format("%s_%s", "gen_user", KibanaUserReindexFilter.getUsernameHash(username));
    }
}

