/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.auditlog.AuditLogModule;
import com.floragunn.searchguard.configuration.BackendModule;
import com.floragunn.searchguard.configuration.ConfigurationModule;
import com.floragunn.searchguard.configuration.SearchGuardIndexSearcherWrapperModule;
import com.floragunn.searchguard.filter.SearchGuardFilter;
import com.floragunn.searchguard.http.SearchGuardHttpServerTransport;
import com.floragunn.searchguard.rest.SearchGuardInfoAction;
import com.floragunn.searchguard.support.ReflectionHelper;
import com.floragunn.searchguard.transport.SearchGuardTransportService;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.transport.TransportModule;

public final class SearchGuardPlugin
extends Plugin {
    private final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());
    private static final String CLIENT_TYPE = "client.type";
    private final Settings settings;
    private final boolean client;
    private final boolean httpSSLEnabled;
    private final boolean tribeNodeClient;

    public SearchGuardPlugin(Settings settings) {
        this.log.info("Clustername: {}", new Object[]{settings.get("cluster.name", "elasticsearch")});
        this.checkSSLPluginAvailable();
        if (!settings.getAsBoolean("searchguard.ssl.transport.enabled", Boolean.valueOf(true)).booleanValue()) {
            throw new IllegalStateException("searchguard.ssl.transport.enabled must be set to 'true'");
        }
        this.settings = settings;
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE, "node"));
        boolean tribeNode = this.settings.getAsBoolean("action.master.force_local", Boolean.valueOf(false)) != false && this.settings.getByPrefix("tribe").getAsMap().size() > 0;
        this.tribeNodeClient = this.settings.get("tribe.name", null) != null;
        this.httpSSLEnabled = settings.getAsBoolean("searchguard.ssl.http.enabled", Boolean.valueOf(false));
        this.log.info("Node [{}] is a transportClient: {}/tribeNode: {}/tribeNodeClient: {}", new Object[]{settings.get("node.name"), this.client, tribeNode, this.tribeNodeClient});
        if (this.client && System.getProperty("sg.nowarn.client") == null) {
            System.out.println("*************************************************************************");
            System.out.println("'Search Guard 2' plugin is normally not needed on transport client nodes.");
            System.out.println("*************************************************************************");
        }
    }

    public String name() {
        return "search-guard2";
    }

    public String description() {
        return "Search Guard 2";
    }

    public Collection<Module> shardModules(Settings settings) {
        if (!this.client && !this.tribeNodeClient) {
            return ImmutableList.of((Object)((Object)new SearchGuardIndexSearcherWrapperModule()));
        }
        return ImmutableList.of();
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (!this.client && !this.tribeNodeClient) {
            modules.add((Module)new ConfigurationModule());
            modules.add((Module)new BackendModule());
            modules.add((Module)new AuditLogModule());
        }
        return modules;
    }

    public void onModule(ActionModule module) {
        if (!this.tribeNodeClient) {
            module.registerAction((GenericAction)ConfigUpdateAction.INSTANCE, TransportConfigUpdateAction.class, new Class[0]);
            if (!this.client) {
                module.registerFilter(SearchGuardFilter.class);
            }
        }
    }

    public void onModule(RestModule module) {
        if (!this.client && !this.tribeNodeClient) {
            module.addRestAction(SearchGuardInfoAction.class);
            if (ReflectionHelper.canLoad("com.floragunn.dlic.rest.api.SearchGuardRestApiActions")) {
                try {
                    ReflectionHelper.load("com.floragunn.dlic.rest.api.SearchGuardRestApiActions").getDeclaredMethod("addActions", RestModule.class).invoke(null, module);
                }
                catch (Exception ex) {
                    this.log.error("Failed to register SearchGuardRestApiActions, management API not available. Cause: {}", new Object[]{ex.getMessage()});
                }
            }
        }
    }

    public void onModule(TransportModule module) {
        if (!this.client && !this.tribeNodeClient) {
            module.setTransportService(SearchGuardTransportService.class, this.name());
        }
    }

    public void onModule(HttpServerModule module) {
        if (!this.client && this.httpSSLEnabled && !this.tribeNodeClient) {
            module.setHttpServerTransport(SearchGuardHttpServerTransport.class, this.name());
        }
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.settingsBuilder();
        return builder.build();
    }

    private void checkSSLPluginAvailable() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.floragunn.searchguard.ssl.SearchGuardSSLPlugin");
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("SearchGuardSSLPlugin must be be installed");
        }
    }
}

