/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;

public class GetResultBuilder {
    private static final ESLogger LOG = Loggers.getLogger(GetResultBuilder.class);
    private String index;
    private String replacedIndex;
    private String type = "";
    private String id = "";
    private long version;
    private boolean exists;
    private GetResponse response;
    private Map<String, GetField> responseFields = new HashMap<String, GetField>();

    public GetResultBuilder index(String index) {
        this.index = index;
        return this;
    }

    public GetResultBuilder replacedIndex(String index) {
        this.replacedIndex = index;
        return this;
    }

    public GetResultBuilder response(GetResponse response) {
        this.response = response;
        if (this.response != null) {
            this.type = (String)ObjectUtils.defaultIfNull((Object)response.getType(), (Object)"");
            this.id = (String)ObjectUtils.defaultIfNull((Object)response.getId(), (Object)"");
            this.version = (Long)ObjectUtils.defaultIfNull((Object)response.getVersion(), (Object)0L);
            this.exists = response.isExists();
            this.responseFields = (Map)ObjectUtils.defaultIfNull((Object)response.getFields(), new HashMap());
        }
        return this;
    }

    public GetResult build() {
        BytesArray replacedContent = null;
        if (this.response != null && !this.response.isSourceEmpty() && this.replacedIndex != null && this.index != null) {
            String source = this.response.getSourceAsBytesRef().toUtf8();
            String replaced = source.replaceAll(this.replacedIndex, this.index);
            replacedContent = new BytesArray(replaced);
        }
        for (String key : this.responseFields.keySet()) {
            GetField replacedField = this.responseFields.get(key);
            for (Object o : replacedField.getValues()) {
                String value;
                if (!(o instanceof String) || !(value = (String)o).contains(this.replacedIndex)) continue;
                replacedField.getValues().remove(o);
                replacedField.getValues().add(value.replaceAll(this.replacedIndex, this.index));
            }
        }
        GetResult result = new GetResult(this.index, this.type, this.id, this.version, this.exists, replacedContent, this.responseFields);
        LOG.debug("Built GetResult: {}", new Object[]{result});
        return result;
    }
}

