/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.RolesMappingBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;

public abstract class BaseRolesMappingSyncStrategy
implements RolesMappingSyncStrategy {
    protected final SearchGuardRolesMapping mappings;

    protected BaseRolesMappingSyncStrategy(SearchGuardRolesMapping mappings) {
        this.mappings = mappings;
    }

    private void removeSyncAcls() {
        for (SearchGuardRolesMapping.RolesMapping mapping : this.mappings) {
            if (mapping.getName() == null || !mapping.getName().startsWith("gen")) continue;
            this.mappings.removeRolesMapping(mapping);
        }
    }

    protected abstract void syncFromImpl(UserProjectCache var1, RolesMappingBuilder var2);

    @Override
    public void syncFrom(UserProjectCache cache) {
        this.removeSyncAcls();
        RolesMappingBuilder builder = new RolesMappingBuilder();
        this.syncFromImpl(cache, builder);
        this.mappings.addAll(builder.build());
    }
}

