/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class IndexMappingLoader
implements ConfigurationSettings {
    private static ESLogger logger = Loggers.getLogger(IndexMappingLoader.class);
    private final String appMappingsTemplate;
    private final String opsMappingsTemplate;
    private final String emptyProjectMappingsTemplate;

    @Inject
    public IndexMappingLoader(Settings settings) {
        this.appMappingsTemplate = this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.app");
        this.opsMappingsTemplate = this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.ops");
        this.emptyProjectMappingsTemplate = this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.empty");
    }

    private String loadMapping(Settings settings, String key) {
        String mapping = settings.get(key);
        if (mapping != null && new File(mapping).exists()) {
            logger.info("Trying to load Kibana mapping for {} from plugin: {}", new Object[]{key, mapping});
            try {
                FileInputStream stream = new FileInputStream(mapping.toString());
                return IOUtils.toString((InputStream)stream);
            }
            catch (Exception e) {
                logger.error("Unable to load the Kibana mapping specified by {}: {}", new Object[]{key, e, mapping});
            }
        }
        throw new RuntimeException("Unable to load index mapping for " + key + ".  The key was not in the settings or it specified a file that does not exists.");
    }

    public String getApplicationMappingsTemplate() {
        return this.appMappingsTemplate;
    }

    public String getOperationsMappingsTemplate() {
        return this.opsMappingsTemplate;
    }

    public String getEmptyProjectMappingsTemplate() {
        return this.emptyProjectMappingsTemplate;
    }
}

