/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.BaseRolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RoleBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UserRolesSyncStrategy
extends BaseRolesSyncStrategy
implements RolesSyncStrategy {
    private final String cdmProjectPrefix;
    private final String kibanaIndexMode;

    public UserRolesSyncStrategy(SearchGuardRoles roles, String userProfilePrefix, String cdmProjectPrefix, String kibanaIndexMode) {
        super(roles, userProfilePrefix);
        this.cdmProjectPrefix = cdmProjectPrefix;
        this.kibanaIndexMode = kibanaIndexMode;
    }

    @Override
    protected void syncFromImpl(UserProjectCache cache, RolesBuilder builder) {
        boolean foundAnOpsUser = false;
        for (Map.Entry<AbstractMap.SimpleImmutableEntry<String, String>, Set<String>> userToProjects : cache.getUserProjects().entrySet()) {
            String token;
            String user = userToProjects.getKey().getKey();
            if (cache.isOperationsUser(user, token = userToProjects.getKey().getValue())) {
                foundAnOpsUser = true;
                continue;
            }
            String roleName = UserRolesSyncStrategy.formatUserRoleName(user);
            String kibIndexName = this.formatKibanaIndexName(cache, user, token, this.kibanaIndexMode);
            RoleBuilder role = new RoleBuilder(roleName).setClusters(USER_ROLE_CLUSTER_ACTIONS).setActions(kibIndexName, "*", KIBANA_ROLE_INDEX_ACTIONS);
            for (String project : userToProjects.getValue()) {
                String indexName = String.format("%s?*", project.replace('.', '?'));
                role.setActions(indexName, "*", PROJECT_ROLE_ACTIONS);
                if (!StringUtils.isNotEmpty((String)this.cdmProjectPrefix)) continue;
                indexName = String.format("%s?%s?*", this.cdmProjectPrefix.replace('.', '?'), project.replace('.', '?'));
                role.setActions(indexName, "*", PROJECT_ROLE_ACTIONS);
            }
            role.setActions(UserRolesSyncStrategy.formatAllAlias(user), "*", PROJECT_ROLE_ACTIONS);
            builder.addRole(role.build());
        }
        if (foundAnOpsUser) {
            RoleBuilder opsRole = new RoleBuilder("gen_project_operations").setClusters(OPERATIONS_ROLE_CLUSTER_ACTIONS).setActions("?operations?", "*", OPERATIONS_ROLE_OPERATIONS_ACTIONS).setActions("*?*?*", "*", OPERATIONS_ROLE_ANY_ACTIONS);
            builder.addRole(opsRole.build());
            RoleBuilder kibanaOpsRole = new RoleBuilder("gen_ocp_kibana_shared").setClusters(KIBANA_ROLE_CLUSTER_ACTIONS).setActions("*", "*", KIBANA_ROLE_ALL_INDEX_ACTIONS);
            builder.addRole(kibanaOpsRole.build());
        }
    }

    public static String formatAllAlias(String user) {
        return ".all_" + user.replaceAll("[\\\\.@/]", "_");
    }
}

