/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.RolesMappingBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class SearchGuardRolesMapping
implements Iterable<RolesMapping>,
SearchGuardACLDocument {
    public static final String ADMIN_ROLE = "gen_project_operations";
    public static final String KIBANA_SHARED_ROLE = "gen_ocp_kibana_shared";
    private static final String USER_HEADER = "users";
    private List<RolesMapping> mappings = new ArrayList<RolesMapping>();

    @Override
    public Iterator<RolesMapping> iterator() {
        return new ArrayList<RolesMapping>(this.mappings).iterator();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void removeRolesMapping(RolesMapping mapping) {
        this.mappings.remove(mapping);
    }

    public SearchGuardRolesMapping load(Map<String, Object> source) {
        RolesMappingBuilder builder = new RolesMappingBuilder();
        for (String key : source.keySet()) {
            HashMap users = (HashMap)source.get(key);
            builder.setUsers(key, (List)users.get(USER_HEADER));
        }
        this.mappings = builder.build();
        return this;
    }

    public Map<String, Object> toMap() {
        TreeMap<String, Object> output = new TreeMap<String, Object>();
        for (RolesMapping mapping : this.mappings) {
            TreeMap<String, List<String>> mappingObject = new TreeMap<String, List<String>>();
            mappingObject.put(USER_HEADER, mapping.getUsers());
            output.put(mapping.getName(), mappingObject);
        }
        return output;
    }

    @Override
    public String getType() {
        return "rolesmapping";
    }

    @Override
    public XContentBuilder toXContentBuilder() {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.map(this.toMap());
            return builder;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert the SearchGuardRolesMapping to JSON", e);
        }
    }

    public void addAll(Collection<RolesMapping> mappings) {
        this.mappings.addAll(mappings);
    }

    public static class RolesMapping {
        private String name;
        private List<String> users = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getUsers() {
            return this.users;
        }

        public void setUsers(List<String> users) {
            this.users = users;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

