/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.BaseRolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.BaseRolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserRolesMappingSyncStrategy
extends BaseRolesMappingSyncStrategy {
    public UserRolesMappingSyncStrategy(SearchGuardRolesMapping mapping) {
        super(mapping);
    }

    @Override
    protected void syncFromImpl(UserProjectCache cache, RolesMappingBuilder builder) {
        HashSet<String> opsUsers = new HashSet<String>();
        for (Map.Entry<AbstractMap.SimpleImmutableEntry<String, String>, Set<String>> userProjects : cache.getUserProjects().entrySet()) {
            String token;
            String username = userProjects.getKey().getKey();
            if (cache.isOperationsUser(username, token = userProjects.getKey().getValue())) {
                opsUsers.add(username);
                continue;
            }
            String roleName = BaseRolesSyncStrategy.formatUserRoleName(username);
            builder.addUser(roleName, username);
        }
        for (String user : opsUsers) {
            builder.addUser("gen_project_operations", user);
            builder.addUser("gen_ocp_kibana_shared", user);
        }
    }
}

