/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLDocument;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardSyncStrategyFactory;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.fabric8.elasticsearch.plugin.kibana.KibanaSeed;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class DynamicACLFilter
extends RestFilter
implements ConfigurationSettings {
    private static final ESLogger LOGGER = Loggers.getLogger(DynamicACLFilter.class);
    private final UserProjectCache cache;
    private final String searchGuardIndex;
    private final String kibanaVersion;
    private final ReentrantLock lock = new ReentrantLock();
    private final String kbnVersionHeader;
    private Boolean enabled;
    private final String cdmProjectPrefix;
    private KibanaSeed kibanaSeed;
    private final Client client;
    private final OpenshiftRequestContextFactory contextFactory;
    private final SearchGuardSyncStrategyFactory documentFactory;

    @Inject
    public DynamicACLFilter(UserProjectCache cache, PluginSettings settings, KibanaSeed seed, Client client, OpenshiftRequestContextFactory contextFactory, SearchGuardSyncStrategyFactory documentFactory) {
        this.client = client;
        this.cache = cache;
        this.kibanaSeed = seed;
        this.contextFactory = contextFactory;
        this.documentFactory = documentFactory;
        this.searchGuardIndex = settings.getSearchGuardIndex();
        this.kibanaVersion = settings.getKibanaVersion();
        this.kbnVersionHeader = settings.getKbnVersionHeader();
        this.cdmProjectPrefix = settings.getCdmProjectPrefix();
        this.enabled = settings.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        boolean continueProcessing = true;
        try {
            if (this.enabled.booleanValue()) {
                String kbnVersion = this.getKibanaVersion(request);
                OpenshiftRequestContextFactory.OpenshiftRequestContext requestContext = this.contextFactory.create(request, this.cache);
                request.putInContext((Object)"x-openshift-request-context", (Object)requestContext);
                if (requestContext.isAuthenticated() && !this.cache.hasUser(requestContext.getUser(), requestContext.getToken()) && this.updateCache(requestContext, kbnVersion)) {
                    this.kibanaSeed.setDashboards(requestContext, this.client, kbnVersion, this.cdmProjectPrefix);
                    this.syncAcl(requestContext);
                }
            }
        }
        catch (ElasticsearchSecurityException ese) {
            LOGGER.info("Could not authenticate user", new Object[0]);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED));
            continueProcessing = false;
        }
        catch (Exception e) {
            LOGGER.error("Error handling request in {}", (Throwable)e, new Object[]{this.getClass().getSimpleName()});
        }
        finally {
            if (continueProcessing) {
                chain.continueProcessing(request, channel);
            }
        }
    }

    private String getKibanaVersion(RestRequest request) {
        String kbnVersion = (String)ObjectUtils.defaultIfNull((Object)request.header(this.kbnVersionHeader), (Object)"");
        if (StringUtils.isEmpty((String)kbnVersion)) {
            return this.kibanaVersion;
        }
        return kbnVersion;
    }

    private boolean updateCache(OpenshiftRequestContextFactory.OpenshiftRequestContext context, String kbnVersion) {
        LOGGER.debug("Updating the cache for user '{}'", new Object[]{context.getUser()});
        try {
            this.cache.update(context.getUser(), context.getToken(), context.getProjects(), context.isOperationsUser());
        }
        catch (Exception e) {
            LOGGER.error("Error updating cache for user '{}'", (Throwable)e, new Object[]{context.getUser()});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAcl(OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        LOGGER.debug("Syncing the ACL to ElasticSearch", new Object[0]);
        try {
            this.lock.lock();
            LOGGER.debug("Loading SearchGuard ACL...", new Object[0]);
            MultiGetRequest mget = new MultiGetRequest();
            mget.putHeader("_sg_conf_request", (Object)"true");
            mget.refresh(true);
            mget.realtime(Boolean.valueOf(true));
            mget.add(this.searchGuardIndex, "roles", "0");
            mget.add(this.searchGuardIndex, "rolesmapping", "0");
            SearchGuardRoles roles = null;
            SearchGuardRolesMapping rolesMapping = null;
            MultiGetResponse response = (MultiGetResponse)this.client.multiGet(mget).actionGet();
            for (MultiGetItemResponse item : response.getResponses()) {
                if (!item.isFailed()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Read in {}: {}", new Object[]{item.getType(), XContentHelper.convertToJson((BytesReference)item.getResponse().getSourceAsBytesRef(), (boolean)true, (boolean)true)});
                    }
                    switch (item.getType()) {
                        case "roles": {
                            roles = new SearchGuardRoles().load(item.getResponse().getSource());
                            break;
                        }
                        case "rolesmapping": {
                            rolesMapping = new SearchGuardRolesMapping().load(item.getResponse().getSource());
                        }
                    }
                    continue;
                }
                LOGGER.error("There was a failure loading document type {}", new Object[]{item.getFailure(), item.getType()});
            }
            if (roles == null || rolesMapping == null) {
                return;
            }
            LOGGER.debug("Syncing from cache to ACL...", new Object[0]);
            RolesMappingSyncStrategy rolesMappingSync = this.documentFactory.createRolesMappingSyncStrategy(rolesMapping);
            rolesMappingSync.syncFrom(this.cache);
            RolesSyncStrategy rolesSync = this.documentFactory.createRolesSyncStrategy(roles);
            rolesSync.syncFrom(this.cache);
            this.writeAcl(roles, rolesMapping);
        }
        catch (Exception e) {
            LOGGER.error("Exception while syncing ACL with cache", (Throwable)e, new Object[0]);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeAcl(SearchGuardACLDocument ... documents) throws Exception {
        BulkRequestBuilder builder = this.client.prepareBulk().setRefresh(true);
        for (SearchGuardACLDocument doc : documents) {
            UpdateRequest update = (UpdateRequest)this.client.prepareUpdate(this.searchGuardIndex, doc.getType(), "0").setConsistencyLevel(WriteConsistencyLevel.DEFAULT).setDoc(doc.toXContentBuilder()).request();
            builder.add(update);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Built {} update request: {}", new Object[]{doc.getType(), XContentHelper.convertToJson((BytesReference)doc.toXContentBuilder().bytes(), (boolean)true, (boolean)true)});
        }
        BulkRequest request = (BulkRequest)builder.request();
        request.putHeader("_sg_conf_request", (Object)"true");
        BulkResponse response = (BulkResponse)this.client.bulk(request).actionGet();
        if (!response.hasFailures()) {
            ConfigUpdateRequest confRequest = new ConfigUpdateRequest(SEARCHGUARD_INITIAL_CONFIGS);
            confRequest.putHeader("_sg_conf_request", (Object)"true");
            ConfigUpdateResponse cur = (ConfigUpdateResponse)this.client.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)confRequest).actionGet();
            if (((ConfigUpdateResponse.Node[])cur.getNodes()).length > 0) {
                LOGGER.debug("Successfully reloaded config with '{}' nodes", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length});
            } else {
                LOGGER.warn("Failed to reloaded configs", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length});
            }
        } else {
            LOGGER.error("Unable to write ACL {}", new Object[]{response.buildFailureMessage()});
        }
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

