/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginClient;
import io.fabric8.elasticsearch.plugin.kibana.DocumentBuilder;
import io.fabric8.elasticsearch.plugin.kibana.IndexMappingLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.transport.RemoteTransportException;

public class KibanaSeed
implements ConfigurationSettings {
    private static final String DEFAULT_INDEX_TYPE = "config";
    private static final String INDICIES_TYPE = "index-pattern";
    private static final String OPERATIONS_PROJECT = ".operations";
    private static final String BLANK_PROJECT = ".empty-project";
    private static final String ADMIN_ALIAS_NAME = ".all";
    private static final ESLogger LOGGER = Loggers.getLogger(KibanaSeed.class);
    public static final String DEFAULT_INDEX_FIELD = "defaultIndex";
    private final IndexMappingLoader mappingLoader;
    private final PluginClient pluginClient;
    private final String defaultKibanaIndex;

    @Inject
    public KibanaSeed(Settings settings, IndexMappingLoader loader, PluginClient pluginClient) {
        this.mappingLoader = loader;
        this.pluginClient = pluginClient;
        this.defaultKibanaIndex = settings.get("kibana.config_index_name", ".kibana");
    }

    public void setDashboards(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client client, String kibanaVersion, String projectPrefix) {
        LOGGER.debug("Begin setDashboards:  projectPrefix '{}' for user '{}' projects '{}' kibanaIndex '{}'", new Object[]{projectPrefix, context.getUser(), context.getProjects(), context.getKibanaIndex()});
        boolean changed = this.initialSeedKibanaIndex(context, client);
        Set<String> indexPatterns = this.getProjectNamesFromIndexes(context, client, projectPrefix);
        LOGGER.debug("Found '{}' Index patterns for user", new Object[]{indexPatterns.size()});
        HashSet<String> projects = new HashSet<String>(context.getProjects());
        ArrayList<String> filteredProjects = new ArrayList<String>(this.filterProjectsWithIndices(projectPrefix, projects));
        LOGGER.debug("projects for '{}' that have existing indexes: '{}'", new Object[]{context.getUser(), filteredProjects});
        if (context.isOperationsUser()) {
            LOGGER.debug("Adding indexes to alias '{}' for user '{}'", new Object[]{ADMIN_ALIAS_NAME, context.getUser()});
            this.buildAdminAlias(filteredProjects, projectPrefix);
            filteredProjects.add(ADMIN_ALIAS_NAME);
            filteredProjects.add(OPERATIONS_PROJECT);
        }
        Collections.sort(filteredProjects);
        if (filteredProjects.isEmpty()) {
            filteredProjects.add(BLANK_PROJECT);
        }
        if (indexPatterns.isEmpty()) {
            this.create(context.getKibanaIndex(), filteredProjects, true, client, kibanaVersion, projectPrefix);
            changed = true;
        } else {
            ArrayList<String> common = new ArrayList<String>(indexPatterns);
            common.retainAll(filteredProjects);
            filteredProjects.removeAll(common);
            indexPatterns.removeAll(common);
            if (!context.isOperationsUser()) {
                LOGGER.debug("user is not a cluster admin, ensure they don't keep/have the admin alias pattern", new Object[0]);
                indexPatterns.add(ADMIN_ALIAS_NAME);
            }
            if (!filteredProjects.isEmpty() || !indexPatterns.isEmpty()) {
                changed = true;
            }
            this.create(context.getKibanaIndex(), filteredProjects, false, client, kibanaVersion, projectPrefix);
            this.remove(context.getKibanaIndex(), indexPatterns, client, projectPrefix);
            common.addAll(filteredProjects);
            Collections.sort(common);
            String defaultIndex = this.getDefaultIndex(context, client, kibanaVersion, projectPrefix);
            LOGGER.debug("Checking if index patterns '{}' contain default index '{}'", new Object[]{indexPatterns, defaultIndex});
            if (indexPatterns.contains(defaultIndex) || StringUtils.isEmpty((String)defaultIndex)) {
                LOGGER.debug("'{}' does contain '{}' and common size is {}", new Object[]{indexPatterns, defaultIndex, common.size()});
                if (!common.isEmpty()) {
                    this.setDefaultIndex(context.getKibanaIndex(), (String)common.get(0), client, kibanaVersion, projectPrefix);
                }
            }
        }
        if (changed) {
            this.refreshKibanaUser(context.getKibanaIndex(), client);
        }
    }

    private List<String> filterProjectsWithIndices(String projectPrefix, Set<String> projects) {
        ArrayList<String> result = new ArrayList<String>(projects.size());
        for (String project : projects) {
            String index = this.getIndexPattern(project, projectPrefix);
            if (!this.pluginClient.indexExists(index)) continue;
            result.add(project);
        }
        return result;
    }

    private void refreshKibanaUser(String kibanaIndex, Client esClient) {
        RefreshRequest request = (RefreshRequest)new RefreshRequest().indices(new String[]{kibanaIndex});
        request.putHeader("_sg_conf_request", (Object)"true");
        RefreshResponse response = (RefreshResponse)esClient.admin().indices().refresh(request).actionGet();
        LOGGER.debug("Refreshed '{}' successfully on {} of {} shards", new Object[]{kibanaIndex, response.getSuccessfulShards(), response.getTotalShards()});
    }

    private boolean initialSeedKibanaIndex(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client esClient) {
        try {
            String userIndex = context.getKibanaIndex();
            boolean kibanaIndexExists = this.pluginClient.indexExists(userIndex);
            LOGGER.debug("Kibana index '{}' exists? {}", new Object[]{userIndex, kibanaIndexExists});
            if (!kibanaIndexExists && !this.defaultKibanaIndex.equals(userIndex)) {
                LOGGER.debug("Copying '{}' to '{}'", new Object[]{this.defaultKibanaIndex, userIndex});
                GetIndexRequest getRequest = (GetIndexRequest)new GetIndexRequest().indices(new String[]{this.defaultKibanaIndex});
                getRequest.putHeader("_sg_conf_request", (Object)"true");
                GetIndexResponse getResponse = (GetIndexResponse)esClient.admin().indices().getIndex(getRequest).get();
                CreateIndexRequest createRequest = new CreateIndexRequest().index(userIndex);
                createRequest.putHeader("_sg_conf_request", (Object)"true");
                createRequest.settings((Settings)getResponse.settings().get((Object)this.defaultKibanaIndex));
                Map configMapping = ((MappingMetaData)((ImmutableOpenMap)getResponse.mappings().get((Object)this.defaultKibanaIndex)).get((Object)DEFAULT_INDEX_TYPE)).getSourceAsMap();
                createRequest.mapping(DEFAULT_INDEX_TYPE, configMapping);
                esClient.admin().indices().create(createRequest).actionGet();
                ClusterHealthRequest healthRequest = new ClusterHealthRequest().indices(new String[]{userIndex}).waitForYellowStatus();
                ((ClusterHealthResponse)esClient.admin().cluster().health(healthRequest).actionGet()).getStatus();
                return true;
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOGGER.error("Unable to create initial Kibana index", (Throwable)e, new Object[0]);
        }
        return false;
    }

    private void setDefaultIndex(String kibanaIndex, String project, Client esClient, String kibanaVersion, String projectPrefix) {
        String source = new DocumentBuilder().defaultIndex(this.getIndexPattern(project, projectPrefix)).build();
        this.executeUpdate(kibanaIndex, DEFAULT_INDEX_TYPE, kibanaVersion, source, esClient);
    }

    private void buildAdminAlias(List<String> projects, String projectPrefix) {
        try {
            if (projects.isEmpty()) {
                return;
            }
            HashMap<String, String> patternAlias = new HashMap<String, String>(projects.size());
            for (String project : projects) {
                patternAlias.put(this.getIndexPattern(project, projectPrefix), ADMIN_ALIAS_NAME);
            }
            this.pluginClient.alias(patternAlias);
        }
        catch (ElasticsearchException e) {
            LOGGER.error("Error executing Alias request", (Throwable)e, new Object[0]);
        }
    }

    private String getDefaultIndex(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client esClient, String kibanaVersion, String projectPrefix) {
        GetRequest request = (GetRequest)((GetRequestBuilder)esClient.prepareGet(context.getKibanaIndex(), DEFAULT_INDEX_TYPE, kibanaVersion).putHeader("_sg_conf_request", (Object)"true")).request();
        try {
            GetResponse response = (GetResponse)esClient.get(request).get();
            Map source = response.getSource();
            if (source != null && source.containsKey(DEFAULT_INDEX_FIELD)) {
                LOGGER.debug("Received response with 'defaultIndex' = {}", new Object[]{source.get(DEFAULT_INDEX_FIELD)});
                String index = (String)source.get(DEFAULT_INDEX_FIELD);
                return this.getProjectFromIndex(index, projectPrefix);
            }
            LOGGER.debug("Received response without 'defaultIndex'", new Object[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof RemoteTransportException && e.getCause().getCause() instanceof IndexNotFoundException) {
                LOGGER.debug("No index found", new Object[0]);
            }
            LOGGER.error("Error getting default index for {}", (Throwable)e, new Object[]{context.getUser()});
        }
        return "";
    }

    private void create(String kibanaIndex, List<String> projects, boolean setDefault, Client esClient, String kibanaVersion, String projectPrefix) {
        boolean defaultSet = !setDefault;
        for (String project : projects) {
            this.createIndex(kibanaIndex, project, esClient, projectPrefix);
            if (defaultSet) continue;
            this.setDefaultIndex(kibanaIndex, project, esClient, kibanaVersion, projectPrefix);
            defaultSet = true;
        }
    }

    private void remove(String kibanaIndex, Set<String> projects, Client esClient, String projectPrefix) {
        for (String project : projects) {
            this.deleteIndex(kibanaIndex, project, esClient, projectPrefix);
        }
    }

    private Set<String> getProjectNamesFromIndexes(OpenshiftRequestContextFactory.OpenshiftRequestContext context, Client esClient, String projectPrefix) {
        HashSet<String> patterns = new HashSet<String>();
        SearchRequest request = ((SearchRequestBuilder)esClient.prepareSearch(new String[]{context.getKibanaIndex()}).setTypes(new String[]{INDICIES_TYPE}).putHeader("_sg_conf_request", (Object)"true")).request();
        try {
            SearchResponse response = (SearchResponse)esClient.search(request).get();
            if (response.getHits() != null && response.getHits().getTotalHits() > 0L) {
                for (SearchHit hit : response.getHits().getHits()) {
                    String id = hit.getId();
                    String project = this.getProjectFromIndex(id, projectPrefix);
                    if (project.equals(id) && !project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) continue;
                    patterns.add(project);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof RemoteTransportException && e.getCause().getCause() instanceof IndexNotFoundException) {
                LOGGER.debug("Encountered IndexMissingException, returning empty response", new Object[0]);
            }
            LOGGER.error("Error getting index patterns for {}", (Throwable)e, new Object[]{context.getUser()});
        }
        return patterns;
    }

    private void createIndex(String kibanaIndex, String project, Client esClient, String projectPrefix) {
        String indexPattern = this.getIndexPattern(project, projectPrefix);
        String source = project.equalsIgnoreCase(OPERATIONS_PROJECT) || project.equalsIgnoreCase(ADMIN_ALIAS_NAME) ? this.mappingLoader.getOperationsMappingsTemplate() : (project.equalsIgnoreCase(BLANK_PROJECT) ? this.mappingLoader.getEmptyProjectMappingsTemplate() : this.mappingLoader.getApplicationMappingsTemplate());
        if (source != null) {
            source = source.replaceAll("$TITLE$", indexPattern);
            this.executeCreate(kibanaIndex, INDICIES_TYPE, indexPattern, source, esClient);
        } else {
            LOGGER.debug("The source for the index mapping is null.  Skipping trying to createIndex {}", new Object[]{indexPattern});
        }
    }

    private void deleteIndex(String kibanaIndex, String project, Client esClient, String projectPrefix) {
        this.executeDelete(kibanaIndex, INDICIES_TYPE, this.getIndexPattern(project, projectPrefix), esClient);
    }

    private void executeCreate(String index, String type, String id, String source, Client esClient) {
        LOGGER.debug("CREATE: '{}/{}/{}' source: '{}'", new Object[]{index, type, id, source});
        IndexRequest request = (IndexRequest)esClient.prepareIndex(index, type, id).setSource(source).request();
        request.putHeader("_sg_conf_request", (Object)"true");
        try {
            esClient.index(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error executing create request", (Throwable)e, new Object[0]);
        }
    }

    private void executeUpdate(String index, String type, String id, String source, Client esClient) {
        LOGGER.debug("UPDATE: '{}/{}/{}' source: '{}'", new Object[]{index, type, id, source});
        UpdateRequest request = (UpdateRequest)esClient.prepareUpdate(index, type, id).setDoc(source).setDocAsUpsert(true).request();
        request.putHeader("_sg_conf_request", (Object)"true");
        LOGGER.debug("Created with update? '{}'", new Object[]{((UpdateResponse)esClient.update(request).actionGet()).isCreated()});
    }

    private void executeDelete(String index, String type, String id, Client esClient) {
        LOGGER.debug("DELETE: '{}/{}/{}'", new Object[]{index, type, id});
        DeleteRequest request = (DeleteRequest)esClient.prepareDelete(index, type, id).request();
        request.putHeader("_sg_conf_request", (Object)"true");
        try {
            esClient.delete(request).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error executing delete request", (Throwable)e, new Object[0]);
        }
    }

    private String getIndexPattern(String project, String projectPrefix) {
        if (project.equalsIgnoreCase(ADMIN_ALIAS_NAME)) {
            return project;
        }
        if (project.equalsIgnoreCase(OPERATIONS_PROJECT) || StringUtils.isEmpty((String)projectPrefix)) {
            return project + ".*";
        }
        return projectPrefix + "." + project + ".*";
    }

    private String getProjectFromIndex(String index, String projectPrefix) {
        if (!StringUtils.isEmpty((String)index)) {
            if (index.equalsIgnoreCase(ADMIN_ALIAS_NAME)) {
                return index;
            }
            int wildcard = index.lastIndexOf(46);
            if (wildcard > 0) {
                int start = 0;
                String projectPrefixTest = projectPrefix;
                if (StringUtils.isNotEmpty((String)projectPrefix)) {
                    projectPrefixTest = projectPrefix + ".";
                }
                if (index.startsWith(projectPrefixTest)) {
                    start = projectPrefixTest.length();
                }
                if (wildcard > start) {
                    return index.substring(start, wildcard);
                }
            }
        }
        return index;
    }
}

