/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.util;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import org.apache.commons.lang.ObjectUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;

public class RequestUtils
implements ConfigurationSettings {
    private static final ESLogger LOGGER = Loggers.getLogger(RequestUtils.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private String proxyUserHeader;

    @Inject
    public RequestUtils(Settings settings) {
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
    }

    public String getUser(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.proxyUserHeader), (Object)"");
    }

    public String getBearerToken(RestRequest request) {
        String[] auth = ((String)ObjectUtils.defaultIfNull((Object)request.header(AUTHORIZATION_HEADER), (Object)"")).split(" ");
        if (auth.length >= 2 && "Bearer".equals(auth[0])) {
            return auth[1];
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOperationsUser(RestRequest request) {
        String user = this.getUser(request);
        String token = this.getBearerToken(request);
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        boolean allowed = false;
        try (DefaultOpenShiftClient osClient = new DefaultOpenShiftClient(builder.build());){
            LOGGER.debug("Submitting a SAR to see if '{}' is able to retrieve logs across the cluster", new Object[]{user});
            SubjectAccessReviewResponse response = (SubjectAccessReviewResponse)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((NamespacedOpenShiftClient)osClient.inAnyNamespace()).subjectAccessReviews().createNew()).withVerb("get")).withResource("pods/log")).done();
            allowed = response.getAllowed();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Exception determining user's '{}' role.", (Throwable)e, new Object[]{user});
            }
            catch (Throwable throwable) {
                LOGGER.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
                throw throwable;
            }
            LOGGER.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
        }
        LOGGER.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
        return allowed;
    }
}

