/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class KibanaUserReindexFilter
extends RestFilter
implements ConfigurationSettings {
    private final ESLogger logger = Loggers.getLogger(KibanaUserReindexFilter.class);
    private final String defaultKibanaIndex;

    public KibanaUserReindexFilter(Settings settings, ESLogger logger) {
        this.defaultKibanaIndex = settings.get("kibana.config_index_name", ".kibana");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        try {
            OpenshiftRequestContextFactory.OpenshiftRequestContext userContext = (OpenshiftRequestContextFactory.OpenshiftRequestContext)ObjectUtils.defaultIfNull((Object)request.getFromContext((Object)"x-openshift-request-context"), (Object)OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY);
            String user = userContext.getUser();
            String kibanaIndex = userContext.getKibanaIndex();
            String requestedIndex = this.getRequestedIndex(request);
            this.logger.debug("user: '{}'/ requested index: '{}'/ kibana index: '{}'", new Object[]{user, requestedIndex, kibanaIndex});
            if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)requestedIndex)) {
                if (requestedIndex.equalsIgnoreCase(this.defaultKibanaIndex)) {
                    this.logger.debug("Request is for a kibana index. Updating to '{}' for user '{}'", new Object[]{kibanaIndex, user});
                    request = this.updateRequestIndex(request, requestedIndex, kibanaIndex);
                    this.logger.debug("URI for request is '{}' after update", new Object[]{request.uri()});
                } else if (requestedIndex.startsWith("_mget")) {
                    this.logger.debug("_mget Request for a kibana index. Updating to '{}' for user '{}'", new Object[]{kibanaIndex, user});
                    request = this.updateMGetRequest(request, ".kibana", kibanaIndex);
                    this.logger.debug("URI for request is '{}' after update", new Object[]{request.uri()});
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling request in OpenShift SearchGuard filter", (Throwable)e, new Object[0]);
        }
        finally {
            chain.continueProcessing(request, channel);
        }
    }

    private RestRequest updateMGetRequest(RestRequest request, String oldIndex, String newIndex) {
        BytesReference content = request.content();
        String stringContent = content.toUtf8();
        String replaced = stringContent.replaceAll("_index\":\"" + oldIndex + "\"", "_index\":\"" + newIndex + "\"");
        NettyHttpRequest nettyRequest = (NettyHttpRequest)request;
        HttpRequest httpRequest = nettyRequest.request();
        BytesArray replacedContent = new BytesArray(replaced);
        BigEndianHeapChannelBuffer buffer = new BigEndianHeapChannelBuffer(replacedContent.array());
        httpRequest.setContent((ChannelBuffer)buffer);
        NettyHttpRequest updatedRequest = new NettyHttpRequest(httpRequest, nettyRequest.getChannel());
        updatedRequest.copyContextAndHeadersFrom((HasContextAndHeaders)request);
        return updatedRequest;
    }

    private RestRequest updateRequestIndex(RestRequest request, String oldIndex, String newIndex) {
        String uri = request.uri();
        String replaced = uri.replace(oldIndex, newIndex);
        NettyHttpRequest nettyRequest = (NettyHttpRequest)request;
        HttpRequest httpRequest = nettyRequest.request();
        httpRequest.setUri(replaced);
        NettyHttpRequest updatedRequest = new NettyHttpRequest(httpRequest, nettyRequest.getChannel());
        updatedRequest.copyContextAndHeadersFrom((HasContextAndHeaders)request);
        return updatedRequest;
    }

    private String getRequestedIndex(RestRequest request) {
        String uri = StringUtils.defaultIfBlank((String)request.uri(), (String)"");
        String[] splitUri = uri.split("/");
        if (splitUri.length > 0) {
            return uri.split("/")[1];
        }
        return "";
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public static String getUsernameHash(String username) {
        return DigestUtils.sha1Hex((String)username);
    }
}

