/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.tools;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.JsonSettingsLoader;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;

public class SearchGuardAdmin {
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MMM-dd_HH-mm-ss", Locale.ENGLISH);
    private static final Settings ENABLE_ALL_ALLOCATIONS_SETTINGS = Settings.builder().put("cluster.routing.allocation.enable", "all").build();

    public static void main(String[] args) {
        try {
            SearchGuardAdmin.main0(args);
        }
        catch (NoNodeAvailableException e) {
            System.out.println("ERR: Cannot connect to elasticsearch. Please refer to elasticsearch logfile for more information");
            System.out.println("Trace:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IndexNotFoundException e) {
            System.out.println("ERR: No searchguard configuartion index found. Pls. execute sgadmin with different command line parameters");
            System.out.println("When you run it for the first time to not specify -us, -era, -dra or -rl");
            System.out.println("For more informations look here: https://github.com/floragunncom/search-guard/issues/228");
            System.exit(-1);
        }
        catch (Exception e) {
            System.out.println("ERR: An unexpected " + e.getClass().getSimpleName() + " occured: " + e.getMessage());
            System.out.println("Trace:");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void main0(String[] args) throws Exception {
        String ts;
        String ks;
        String kspass;
        System.setProperty("sg.nowarn.client", "true");
        HelpFormatter formatter = new HelpFormatter();
        Options options = new Options();
        options.addOption("nhnv", "disable-host-name-verification", false, "Disable hostname verification");
        options.addOption("nrhn", "disable-resolve-hostname", false, "Disable hostname beeing resolved");
        options.addOption(Option.builder((String)"ts").longOpt("truststore").hasArg().argName("file").required().desc("Path to truststore (JKS/PKCS12 format)").build());
        options.addOption(Option.builder((String)"ks").longOpt("keystore").hasArg().argName("file").required().desc("Path to keystore (JKS/PKCS12 format").build());
        options.addOption(Option.builder((String)"tst").longOpt("truststore-type").hasArg().argName("type").desc("JKS or PKCS12, if not given use file ext. to dectect type").build());
        options.addOption(Option.builder((String)"kst").longOpt("keystore-type").hasArg().argName("type").desc("JKS or PKCS12, if not given use file ext. to dectect type").build());
        options.addOption(Option.builder((String)"tspass").longOpt("truststore-password").hasArg().argName("password").desc("Truststore password").build());
        options.addOption(Option.builder((String)"kspass").longOpt("keystore-password").hasArg().argName("password").desc("Keystore password").build());
        options.addOption(Option.builder((String)"cd").longOpt("configdir").hasArg().argName("directory").desc("Directory for config files").build());
        options.addOption(Option.builder((String)"h").longOpt("hostname").hasArg().argName("host").desc("Elasticsearch host").build());
        options.addOption(Option.builder((String)"p").longOpt("port").hasArg().argName("port").desc("Elasticsearch transport port (normally 9300)").build());
        options.addOption(Option.builder((String)"cn").longOpt("clustername").hasArg().argName("clustername").desc("Clustername").build());
        options.addOption("sniff", "enable-sniffing", false, "Enable client.transport.sniff");
        options.addOption("icl", "ignore-clustername", false, "Ignore clustername");
        options.addOption(Option.builder((String)"r").longOpt("retrieve").desc("retrieve current config").build());
        options.addOption(Option.builder((String)"f").longOpt("file").hasArg().argName("file").desc("file").build());
        options.addOption(Option.builder((String)"t").longOpt("type").hasArg().argName("file-type").desc("file-type").build());
        options.addOption(Option.builder((String)"tsalias").longOpt("truststore-alias").hasArg().argName("alias").desc("Truststore alias").build());
        options.addOption(Option.builder((String)"ksalias").longOpt("keystore-alias").hasArg().argName("alias").desc("Keystore alias").build());
        options.addOption(Option.builder((String)"ec").longOpt("enabled-ciphers").hasArg().argName("cipers").desc("Comma separated list of TLS ciphers").build());
        options.addOption(Option.builder((String)"ep").longOpt("enabled-protocols").hasArg().argName("protocols").desc("Comma separated list of TLS protocols").build());
        options.addOption(Option.builder((String)"us").longOpt("update_settings").hasArg().argName("number of replicas").desc("update the number of replicas and reload configuration on all nodes and exit").build());
        options.addOption(Option.builder((String)"i").longOpt("index").hasArg().argName("indexname").desc("The index Searchguard uses to store its configs in").build());
        options.addOption(Option.builder((String)"era").longOpt("enable-replica-autoexpand").desc("enable replica auto expand and exit").build());
        options.addOption(Option.builder((String)"dra").longOpt("disable-replica-autoexpand").desc("disable replica auto expand and exit").build());
        options.addOption(Option.builder((String)"rl").longOpt("reload").desc("reload configuration on all nodes and exit").build());
        options.addOption(Option.builder((String)"ff").longOpt("fail-fast").desc("fail-fast if something goes wrong").build());
        options.addOption(Option.builder((String)"dg").longOpt("diagnose").desc("Log diagnostic trace into a file").build());
        options.addOption(Option.builder((String)"dci").longOpt("delete-config-index").desc("Delete 'searchguard' config index and exit.").build());
        options.addOption(Option.builder((String)"esa").longOpt("enable-shard-allocation").desc("Enable all shard allocation and exit.").build());
        String hostname = "localhost";
        int port = 9300;
        String tspass = kspass = "changeit";
        String cd = ".";
        String kst = null;
        String tst = null;
        boolean nhnv = false;
        boolean nrhn = false;
        boolean sniff = false;
        boolean icl = false;
        String clustername = "elasticsearch";
        String file = null;
        String type = null;
        boolean retrieve = false;
        String ksAlias = null;
        String tsAlias = null;
        String[] enabledProtocols = new String[]{};
        String[] enabledCiphers = new String[]{};
        Integer updateSettings = null;
        String index = "searchguard";
        Boolean replicaAutoExpand = null;
        boolean reload = false;
        boolean failFast = false;
        boolean diagnose = false;
        boolean deleteConfigIndex = false;
        boolean enableShardAllocation = false;
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            hostname = line.getOptionValue("h", hostname);
            port = Integer.parseInt(line.getOptionValue("p", String.valueOf(port)));
            kspass = line.getOptionValue("kspass", kspass);
            tspass = line.getOptionValue("tspass", tspass);
            cd = line.getOptionValue("cd", cd);
            if (!cd.endsWith(File.separator)) {
                cd = cd + File.separator;
            }
            ks = line.getOptionValue("ks");
            ts = line.getOptionValue("ts");
            kst = line.getOptionValue("kst", kst);
            tst = line.getOptionValue("tst", tst);
            nhnv = line.hasOption("nhnv");
            nrhn = line.hasOption("nrhn");
            clustername = line.getOptionValue("cn", clustername);
            sniff = line.hasOption("sniff");
            icl = line.hasOption("icl");
            file = line.getOptionValue("f", file);
            type = line.getOptionValue("t", type);
            retrieve = line.hasOption("r");
            ksAlias = line.getOptionValue("ksalias", ksAlias);
            tsAlias = line.getOptionValue("tsalias", tsAlias);
            index = line.getOptionValue("i", index);
            String enabledCiphersString = line.getOptionValue("ec", null);
            String enabledProtocolsString = line.getOptionValue("ep", null);
            if (enabledCiphersString != null) {
                enabledCiphers = enabledCiphersString.split(",");
            }
            if (enabledProtocolsString != null) {
                enabledProtocols = enabledProtocolsString.split(",");
            }
            updateSettings = line.hasOption("us") ? Integer.valueOf(Integer.parseInt(line.getOptionValue("us"))) : null;
            reload = line.hasOption("rl");
            if (line.hasOption("era")) {
                replicaAutoExpand = true;
            }
            if (line.hasOption("dra")) {
                replicaAutoExpand = false;
            }
            failFast = line.hasOption("ff");
            diagnose = line.hasOption("dg");
            deleteConfigIndex = line.hasOption("dci");
            enableShardAllocation = line.hasOption("esa");
        }
        catch (ParseException exp) {
            System.err.println("ERR: Parsing failed.  Reason: " + exp.getMessage());
            formatter.printHelp("sgadmin.sh", options, true);
            return;
        }
        if (port < 9300) {
            System.out.println("WARNING: Seems you want connect to the a HTTP port." + System.lineSeparator() + "         sgadmin connect through the transport port which is normally 9300.");
        }
        System.out.print("Will connect to " + hostname + ":" + port);
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(hostname, port));
        }
        catch (ConnectException ex) {
            System.out.println();
            System.out.println("ERR: Seems there is no elasticsearch running on " + hostname + ":" + port + " - Will exit");
            System.exit(-1);
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception ex) {}
        }
        System.out.println(" ... done");
        Settings.Builder settingsBuilder = Settings.builder().put("path.home", ".").put("path.conf", ".").put("searchguard.ssl.transport.keystore_filepath", ks).put("searchguard.ssl.transport.truststore_filepath", ts).put("searchguard.ssl.transport.keystore_password", kspass).put("searchguard.ssl.transport.truststore_password", tspass).put("searchguard.ssl.transport.enforce_hostname_verification", !nhnv).put("searchguard.ssl.transport.resolve_hostname", !nrhn).put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_type", kst == null ? (ks.endsWith(".jks") ? "JKS" : "PKCS12") : kst).put("searchguard.ssl.transport.truststore_type", tst == null ? (ts.endsWith(".jks") ? "JKS" : "PKCS12") : tst).putArray("searchguard.ssl.transport.enabled_ciphers", enabledCiphers).putArray("searchguard.ssl.transport.enabled_protocols", enabledProtocols).put("cluster.name", clustername).put("client.transport.ignore_cluster_name", icl).put("client.transport.sniff", sniff);
        if (ksAlias != null) {
            settingsBuilder.put("searchguard.ssl.transport.keystore_alias", ksAlias);
        }
        if (tsAlias != null) {
            settingsBuilder.put("searchguard.ssl.transport.truststore_alias", tsAlias);
        }
        Settings settings = settingsBuilder.build();
        try (TransportClient tc = TransportClient.builder().settings(settings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build().addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(hostname, port)));){
            boolean success;
            UpdateSettingsResponse response;
            Settings indexSettings;
            if (updateSettings != null) {
                indexSettings = Settings.builder().put("index.number_of_replicas", updateSettings.intValue()).build();
                tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
                response = (UpdateSettingsResponse)tc.admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{index}).settings(indexSettings)).actionGet();
                System.out.println("Reload config on all nodes");
                System.out.println("Update number of replicas to " + updateSettings + " with result: " + response.isAcknowledged());
                System.exit(response.isAcknowledged() ? 0 : -1);
            }
            if (reload) {
                tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
                System.out.println("Reload config on all nodes");
                System.exit(0);
            }
            if (replicaAutoExpand != null) {
                indexSettings = Settings.builder().put("index.auto_expand_replicas", replicaAutoExpand != false ? "0-all" : "false").build();
                tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet();
                response = (UpdateSettingsResponse)tc.admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{index}).settings(indexSettings)).actionGet();
                System.out.println("Reload config on all nodes");
                System.out.println("Auto-expand replicas " + (replicaAutoExpand != false ? "enabled" : "disabled"));
                System.exit(response.isAcknowledged() ? 0 : -1);
            }
            if (enableShardAllocation) {
                boolean successful = ((ClusterUpdateSettingsResponse)tc.admin().cluster().updateSettings(new ClusterUpdateSettingsRequest().transientSettings(ENABLE_ALL_ALLOCATIONS_SETTINGS).persistentSettings(ENABLE_ALL_ALLOCATIONS_SETTINGS)).actionGet()).isAcknowledged();
                if (successful) {
                    System.out.println("Persistent and transient shard allocation enabled");
                } else {
                    System.out.println("ERR: Unable to enable shard allocation");
                }
                System.exit(successful ? 0 : -1);
            }
            if (failFast) {
                System.out.println("Failfast is activated");
            }
            if (diagnose) {
                SearchGuardAdmin.generateDiagnoseTrace((Client)tc);
            }
            System.out.println("Contacting elasticsearch cluster '" + clustername + "' and wait for YELLOW clusterstate ...");
            ClusterHealthResponse chr = null;
            while (chr == null) {
                try {
                    chr = (ClusterHealthResponse)tc.admin().cluster().health(new ClusterHealthRequest().timeout(TimeValue.timeValueMinutes((long)5L)).waitForYellowStatus()).actionGet();
                }
                catch (Exception e) {
                    if (!failFast) {
                        System.out.println("Cannot retrieve cluster state due to: " + e.getMessage() + ". This is not an error, will keep on trying ...");
                        System.out.println("   * Try running sgadmin.sh with -icl and -nhnv (If thats works you need to check your clustername as well as hostnames in your SSL certificates)");
                        System.out.println("   * If this is not working, try running sgadmin.sh with --diagnose and see diagnose trace log file)");
                    } else {
                        System.out.println("ERR: Cannot retrieve cluster state due to: " + e.getMessage() + ".");
                        System.out.println("   * Try running sgadmin.sh with -icl and -nhnv (If thats works you need to check your clustername as well as hostnames in your SSL certificates)");
                        System.out.println("   * If this is not working, try running sgadmin.sh with --diagnose and see diagnose trace log file)");
                        System.exit(-1);
                    }
                    Thread.sleep(3000L);
                }
            }
            boolean timedOut = chr.isTimedOut();
            if (timedOut) {
                System.out.println("ERR: Timed out while waiting for a green or yellow cluster state.");
                System.out.println("   * Try running sgadmin.sh with -icl and -nhnv (If thats works you need to check your clustername as well as hostnames in your SSL certificates)");
                System.exit(-1);
            }
            System.out.println("Clustername: " + chr.getClusterName());
            System.out.println("Clusterstate: " + chr.getStatus());
            System.out.println("Number of nodes: " + chr.getNumberOfNodes());
            System.out.println("Number of data nodes: " + chr.getNumberOfDataNodes());
            boolean indexExists = ((IndicesExistsResponse)tc.admin().indices().exists(new IndicesExistsRequest(new String[]{index})).actionGet()).isExists();
            NodesInfoResponse nodesInfo = (NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet();
            if (deleteConfigIndex) {
                boolean success2 = true;
                if (indexExists) {
                    success2 = ((DeleteIndexResponse)tc.admin().indices().delete(new DeleteIndexRequest(index)).actionGet()).isAcknowledged();
                    System.out.print("Deleted index '" + index + "'");
                } else {
                    System.out.print("No index '" + index + "' exists, so no need to delete it");
                }
                System.exit(success2 ? 0 : -1);
            }
            if (!indexExists) {
                System.out.print(index + " index does not exists, attempt to create it ... ");
                int replicas = chr.getNumberOfDataNodes() - 1;
                boolean indexCreated = ((CreateIndexResponse)tc.admin().indices().create(new CreateIndexRequest(index).settings(new Object[]{"index.number_of_shards", 1, "index.number_of_replicas", replicas})).actionGet()).isAcknowledged();
                if (indexCreated) {
                    System.out.println("done (with " + replicas + " replicas, auto expand replicas is off)");
                } else {
                    System.out.println("failed!");
                    System.out.println("FAIL: Unable to create the " + index + " index. See elasticsearch logs for more details");
                    System.exit(-1);
                }
            } else {
                System.out.println(index + " index already exists, so we do not need to create one.");
                try {
                    ClusterHealthResponse chrsg = (ClusterHealthResponse)tc.admin().cluster().health(new ClusterHealthRequest(new String[]{index})).actionGet();
                    if (chrsg.isTimedOut()) {
                        System.out.println("ERR: Timed out while waiting for " + index + " index state.");
                    }
                    if (chrsg.getStatus() == ClusterHealthStatus.RED) {
                        System.out.println("ERR: " + index + " index state is RED.");
                    }
                    if (chrsg.getStatus() == ClusterHealthStatus.YELLOW) {
                        System.out.println("INFO: " + index + " index state is YELLOW, it seems you miss some replicas");
                    }
                }
                catch (Exception e) {
                    if (!failFast) {
                        System.out.println("Cannot retrieve " + index + " index state state due to " + e.getMessage() + ". This is not an error, will keep on trying ...");
                    }
                    System.out.println("ERR: Cannot retrieve " + index + " index state state due to " + e.getMessage() + ".");
                    System.exit(-1);
                }
            }
            if (retrieve) {
                String date = DATE_FORMAT.format(new Date());
                success = SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_config_" + date + ".yml", index, "config");
                success &= SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_roles_" + date + ".yml", index, "roles");
                success &= SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_roles_mapping_" + date + ".yml", index, "rolesmapping");
                success &= SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_internal_users_" + date + ".yml", index, "internalusers");
                System.exit((success &= SearchGuardAdmin.retrieveFile((Client)tc, cd + "sg_action_groups_" + date + ".yml", index, "actiongroups")) ? 0 : -1);
            }
            boolean isCdAbs = new File(cd).isAbsolute();
            System.out.println("Populate config from " + (isCdAbs ? cd : new File(".", cd).getCanonicalPath()));
            if (file != null) {
                if (type == null) {
                    System.out.println("ERR: type missing");
                    System.exit(-1);
                }
                if (!Arrays.asList("config", "roles", "rolesmapping", "internalusers", "actiongroups").contains(type)) {
                    System.out.println("ERR: Invalid type '" + type + "'");
                    System.exit(-1);
                }
                System.exit((success = SearchGuardAdmin.uploadFile((Client)tc, file, index, type)) ? 0 : -1);
            }
            success = SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_config.yml", index, "config");
            success &= SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_roles.yml", index, "roles");
            success &= SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_roles_mapping.yml", index, "rolesmapping");
            success &= SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_internal_users.yml", index, "internalusers");
            if (failFast && !(success &= SearchGuardAdmin.uploadFile((Client)tc, cd + "sg_action_groups.yml", index, "actiongroups"))) {
                System.out.println("ERR: cannot upload configuration, see errors above");
                System.exit(-1);
            }
            ConfigUpdateResponse cur = (ConfigUpdateResponse)((Object)tc.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"})).actionGet());
            System.out.println("Done with " + ((success &= SearchGuardAdmin.checkConfigUpdateResponse(cur, nodesInfo, 5)) ? "success" : "failures"));
            System.exit(success ? 0 : -1);
        }
    }

    private static boolean checkConfigUpdateResponse(ConfigUpdateResponse response, NodesInfoResponse nir, int expectedConfigCount) {
        boolean success;
        int expectedNodeCount = 0;
        for (NodeInfo ni : nir) {
            Settings nodeSettings = ni.getSettings();
            if (nodeSettings.get("tribe.name", null) != null) continue;
            ++expectedNodeCount;
        }
        boolean bl = success = ((ConfigUpdateResponse.Node[])response.getNodes()).length == expectedNodeCount;
        if (!success) {
            System.out.println("FAIL: Expected " + expectedNodeCount + " nodes to return response, but got only " + ((ConfigUpdateResponse.Node[])response.getNodes()).length);
        }
        for (String nodeId : response.getNodesMap().keySet()) {
            boolean successNode;
            ConfigUpdateResponse.Node node = (ConfigUpdateResponse.Node)((Object)response.getNodesMap().get(nodeId));
            boolean bl2 = successNode = node.getUpdatedConfigTypes() != null && node.getUpdatedConfigTypes().length == expectedConfigCount;
            if (!successNode) {
                System.out.println("FAIL: Expected " + expectedConfigCount + " config types for node " + nodeId + " but got only " + Arrays.toString(node.getUpdatedConfigTypes()) + " due to: " + node.getMessage() == null ? "unknown reason" : node.getMessage());
            }
            success &= successNode;
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean uploadFile(Client tc, String filepath, String index, String type) {
        System.out.println("Will update '" + type + "' with " + filepath);
        try (FileReader reader = new FileReader(filepath);){
            String id = ((IndexResponse)tc.index(((IndexRequest)new IndexRequest(index).type(type).id("0").refresh(true).consistencyLevel(WriteConsistencyLevel.DEFAULT)).source(SearchGuardAdmin.readXContent(reader, XContentType.YAML))).actionGet()).getId();
            if ("0".equals(id)) {
                System.out.println("   SUCC: Configuration for '" + type + "' created or updated");
                boolean bl = true;
                return bl;
            }
            System.out.println("   FAIL: Configuration for '" + type + "' failed for unknown reasons. Pls. consult logfile of elasticsearch");
            return false;
        }
        catch (Exception e) {
            System.out.println("   FAIL: Configuration for '" + type + "' failed because of " + e.toString());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean retrieveFile(Client tc, String filepath, String index, String type) {
        System.out.println("Will retrieve '" + type + "' into " + filepath);
        try (FileWriter writer = new FileWriter(filepath);){
            GetResponse response = (GetResponse)tc.get(new GetRequest(index).type(type).id("0").refresh(true).realtime(Boolean.valueOf(false))).actionGet();
            if (response.isExists()) {
                if (response.isSourceEmpty()) {
                    System.out.println("   FAIL: Configuration for '" + type + "' failed because of empty source");
                    boolean bl = false;
                    return bl;
                }
                String yaml = SearchGuardAdmin.convertToYaml(response.getSourceAsBytesRef(), true);
                writer.write(yaml);
                System.out.println("   SUCC: Configuration for '" + type + "' stored in " + filepath);
                boolean bl = true;
                return bl;
            }
            System.out.println("   FAIL: Get configuration for '" + type + "' because it does not exist");
            return false;
        }
        catch (Exception e) {
            System.out.println("   FAIL: Get configuration for '" + type + "' failed because of " + e.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BytesReference readXContent(Reader reader, XContentType xContentType) throws IOException {
        BytesReference retVal;
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)xContentType).createParser(reader);
            parser.nextToken();
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.copyCurrentStructure(parser);
            retVal = builder.bytes();
        }
        Settings.builder().put(new JsonSettingsLoader().load(XContentHelper.createParser((BytesReference)retVal))).build();
        return retVal;
    }

    private static String convertToYaml(BytesReference bytes, boolean prettyPrint) throws IOException {
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentFactory.xContentType((BytesReference)bytes)).createParser((InputStream)bytes.streamInput());){
            parser.nextToken();
            XContentBuilder builder = XContentFactory.yamlBuilder();
            if (prettyPrint) {
                builder.prettyPrint();
            }
            builder.copyCurrentStructure(parser);
            String string = builder.string();
            return string;
        }
    }

    protected static void generateDiagnoseTrace(Client tc) {
        ClusterHealthResponse nir;
        String date = DATE_FORMAT.format(new Date());
        StringBuilder sb = new StringBuilder();
        sb.append("Diagnostic sgadmin trace" + System.lineSeparator());
        sb.append("ES client version: " + Version.CURRENT + System.lineSeparator());
        sb.append("Client properties: " + System.getProperties() + System.lineSeparator());
        sb.append(date + System.lineSeparator());
        sb.append(System.lineSeparator());
        try {
            sb.append("ClusterHealthRequest:" + System.lineSeparator());
            nir = (ClusterHealthResponse)tc.admin().cluster().health(new ClusterHealthRequest()).actionGet();
            sb.append(XContentHelper.toString((ToXContent)nir));
        }
        catch (Exception e1) {
            sb.append(ExceptionsHelper.stackTrace((Throwable)e1));
        }
        try {
            sb.append(System.lineSeparator() + "NodesInfoResponse:" + System.lineSeparator());
            nir = (NodesInfoResponse)tc.admin().cluster().nodesInfo(new NodesInfoRequest()).actionGet();
            sb.append(XContentHelper.toString((ToXContent)nir));
        }
        catch (Exception e1) {
            sb.append(ExceptionsHelper.stackTrace((Throwable)e1));
        }
        try {
            sb.append(System.lineSeparator() + "NodesStatsRequest:" + System.lineSeparator());
            nir = (NodesStatsResponse)tc.admin().cluster().nodesStats(new NodesStatsRequest()).actionGet();
            sb.append(XContentHelper.toString((ToXContent)nir));
        }
        catch (Exception e1) {
            sb.append(ExceptionsHelper.stackTrace((Throwable)e1));
        }
        try {
            sb.append(System.lineSeparator() + "PendingClusterTasksRequest:" + System.lineSeparator());
            nir = (PendingClusterTasksResponse)tc.admin().cluster().pendingClusterTasks(new PendingClusterTasksRequest()).actionGet();
            sb.append(XContentHelper.toString((ToXContent)nir));
        }
        catch (Exception e1) {
            sb.append(ExceptionsHelper.stackTrace((Throwable)e1));
        }
        try {
            sb.append(System.lineSeparator() + "ClusterStateRequest:" + System.lineSeparator());
            nir = (ClusterStateResponse)tc.admin().cluster().state(new ClusterStateRequest()).actionGet();
            sb.append(XContentHelper.toString((ToXContent)nir.getState()));
        }
        catch (Exception e1) {
            sb.append(ExceptionsHelper.stackTrace((Throwable)e1));
        }
        try {
            sb.append(System.lineSeparator() + "IndicesStatsRequest:" + System.lineSeparator());
            nir = (IndicesStatsResponse)tc.admin().indices().stats(new IndicesStatsRequest()).actionGet();
            sb.append(XContentHelper.toString((ToXContent)nir));
        }
        catch (Exception e1) {
            sb.append(ExceptionsHelper.stackTrace((Throwable)e1));
        }
        try {
            File dfile = new File("sgadmin_diag_trace_" + date + ".txt");
            Files.write((CharSequence)sb, (File)dfile, (Charset)Charset.forName("UTF-8"));
            System.out.println("Diagnostic trace written to: " + dfile.getAbsolutePath());
        }
        catch (Exception e1) {
            System.out.println("ERR: cannot write diag trace file due to " + e1);
        }
    }
}

