/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.support;

import com.floragunn.searchguard.user.AuthCredentials;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.elasticsearch.common.logging.ESLogger;

public class HTTPHelper {
    public static AuthCredentials extractCredentials(String authorizationHeader, ESLogger log) {
        if (authorizationHeader != null) {
            if (!authorizationHeader.trim().toLowerCase().startsWith("basic ")) {
                log.warn("No 'Basic Authorization' header, send 401 and 'WWW-Authenticate Basic'", new Object[0]);
                return null;
            }
            String decodedBasicHeader = new String(DatatypeConverter.parseBase64Binary((String)authorizationHeader.split(" ")[1]), StandardCharsets.UTF_8);
            int firstColonIndex = decodedBasicHeader.indexOf(58);
            String username = null;
            String password = null;
            if (firstColonIndex > 0) {
                username = decodedBasicHeader.substring(0, firstColonIndex);
                password = decodedBasicHeader.length() - 1 != firstColonIndex ? decodedBasicHeader.substring(firstColonIndex + 1) : "";
            }
            if (username == null || password == null) {
                log.warn("Invalid 'Authorization' header, send 401 and 'WWW-Authenticate Basic'", new Object[0]);
                return null;
            }
            return new AuthCredentials(username, password.getBytes(StandardCharsets.UTF_8)).markComplete();
        }
        log.trace("No 'Authorization' header, send 401 and 'WWW-Authenticate Basic'", new Object[0]);
        return null;
    }
}

