/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingBuilder;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SearchGuardRolesMapping
implements Iterable<RolesMapping> {
    private static final String USER_HEADER = "users";
    private static final String ADMIN_ROLE = "sg_project_operations";
    private List<RolesMapping> mappings;

    @Override
    public Iterator<RolesMapping> iterator() {
        return new ArrayList<RolesMapping>(this.mappings).iterator();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void removeRolesMapping(RolesMapping mapping) {
        this.mappings.remove(mapping);
    }

    public void syncFrom(UserProjectCache cache, String userProfilePrefix) {
        this.removeSyncAcls();
        RolesMappingBuilder builder = new RolesMappingBuilder();
        for (Map.Entry<AbstractMap.SimpleImmutableEntry<String, String>, Set<String>> userProjects : cache.getUserProjects().entrySet()) {
            String username = userProjects.getKey().getKey();
            String token = userProjects.getKey().getValue();
            String usernameHash = KibanaUserReindexFilter.getUsernameHash(username);
            String kibanaRoleName = String.format("%s_%s_%s", "gen", "kibana", usernameHash);
            builder.addUser(kibanaRoleName, username);
            for (String project : userProjects.getValue()) {
                String projectRoleName = String.format("%s_%s", "gen_project", project.replace('.', '_'));
                builder.addUser(projectRoleName, username);
            }
            if (!cache.isOperationsUser(username, token)) continue;
            builder.addUser(ADMIN_ROLE, username);
        }
        this.mappings.addAll(builder.build());
    }

    private void removeSyncAcls() {
        for (RolesMapping mapping : new ArrayList<RolesMapping>(this.mappings)) {
            if (mapping.getName() == null || !mapping.getName().startsWith("gen")) continue;
            this.removeRolesMapping(mapping);
        }
    }

    public SearchGuardRolesMapping load(Map<String, Object> source) {
        RolesMappingBuilder builder = new RolesMappingBuilder();
        for (String key : source.keySet()) {
            HashMap users = (HashMap)source.get(key);
            builder.setUsers(key, (List)users.get(USER_HEADER));
        }
        this.mappings = builder.build();
        return this;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (RolesMapping mapping : this.mappings) {
            HashMap<String, List<String>> mappingObject = new HashMap<String, List<String>>();
            mappingObject.put(USER_HEADER, mapping.getUsers());
            output.put(mapping.getName(), mappingObject);
        }
        return output;
    }

    public static class RolesMapping {
        private String name;
        private List<String> users = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getUsers() {
            return this.users;
        }

        public void setUsers(List<String> users) {
            this.users = users;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

