/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceFluent;

public class SecretBuildSourceFluentImpl<A extends SecretBuildSourceFluent<A>>
extends BaseFluent<A>
implements SecretBuildSourceFluent<A> {
    private String destinationDir;
    private VisitableBuilder<? extends LocalObjectReference, ?> secret;

    public SecretBuildSourceFluentImpl() {
    }

    public SecretBuildSourceFluentImpl(SecretBuildSource instance) {
        this.withDestinationDir(instance.getDestinationDir());
        this.withSecret(instance.getSecret());
    }

    @Override
    public String getDestinationDir() {
        return this.destinationDir;
    }

    @Override
    public A withDestinationDir(String destinationDir) {
        this.destinationDir = destinationDir;
        return (A)this;
    }

    @Override
    public LocalObjectReference getSecret() {
        return this.secret != null ? (LocalObjectReference)this.secret.build() : null;
    }

    @Override
    public A withSecret(LocalObjectReference secret) {
        if (secret != null) {
            this.secret = new LocalObjectReferenceBuilder(secret);
            this._visitables.add(this.secret);
        }
        return (A)this;
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> withNewSecret() {
        return new SecretNestedImpl();
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> withNewSecretLike(LocalObjectReference item) {
        return new SecretNestedImpl(item);
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    @Override
    public A withNewSecret(String name) {
        return this.withSecret(new LocalObjectReference(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretBuildSourceFluentImpl that = (SecretBuildSourceFluentImpl)o;
        if (this.destinationDir != null ? !this.destinationDir.equals(that.destinationDir) : that.destinationDir != null) {
            return false;
        }
        return !(this.secret != null ? !this.secret.equals(that.secret) : that.secret != null);
    }

    public class SecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretBuildSourceFluent.SecretNested<N>>
    implements SecretBuildSourceFluent.SecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecretBuildSourceFluentImpl.this.withSecret(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }
}

