/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluent;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentConfigStatusBuilder
extends DeploymentConfigStatusFluentImpl<DeploymentConfigStatusBuilder>
implements VisitableBuilder<DeploymentConfigStatus, DeploymentConfigStatusBuilder> {
    DeploymentConfigStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentConfigStatusBuilder() {
        this(true);
    }

    public DeploymentConfigStatusBuilder(Boolean validationEnabled) {
        this(new DeploymentConfigStatus(), validationEnabled);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentConfigStatus(), validationEnabled);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent, DeploymentConfigStatus instance) {
        this(fluent, instance, true);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent, DeploymentConfigStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDetails(instance.getDetails());
        fluent.withLatestVersion(instance.getLatestVersion());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDetails(instance.getDetails());
        this.withLatestVersion(instance.getLatestVersion());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DeploymentConfigStatus build() {
        DeploymentConfigStatus buildable = new DeploymentConfigStatus(this.fluent.getDetails(), this.fluent.getLatestVersion(), this.fluent.getObservedGeneration());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigStatusBuilder that = (DeploymentConfigStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

