/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class IndexMappingLoader
implements ConfigurationSettings {
    public static final String DEFAULT_OPERATIONS_MAPPING = "io/fabric8/elasticsearch/plugin/kibana/operations_mapping.json";
    public static final String DEFAULT_APPLICATIONS_MAPPING = "io/fabric8/elasticsearch/plugin/kibana/applications_mapping.json";
    public static final String DEFAULT_EMPTY_MAPPING = "io/fabric8/elasticsearch/plugin/kibana/empty_project_mappings.json";
    private static ESLogger logger = Loggers.getLogger(IndexMappingLoader.class);
    private final String appMappingsTemplate;
    private final String opsMappingsTemplate;
    private final String emptyProjectMappingsTemplate;

    @Inject
    public IndexMappingLoader(Settings settings) {
        this.appMappingsTemplate = this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.app", DEFAULT_APPLICATIONS_MAPPING);
        this.opsMappingsTemplate = this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.ops", DEFAULT_OPERATIONS_MAPPING);
        this.emptyProjectMappingsTemplate = this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.empty", DEFAULT_EMPTY_MAPPING);
    }

    private String loadMapping(Settings settings, String key, String keyDefault) {
        String mapping = settings.get(key);
        if (mapping != null && new File(mapping).exists()) {
            logger.info("Trying to load Kibana mapping for {} from plugin: {}", new Object[]{key, mapping});
            try {
                FileInputStream stream = new FileInputStream(mapping.toString());
                return IOUtils.toString((InputStream)stream);
            }
            catch (Exception e) {
                logger.error("Unable to load the Kibana mapping specified by {}: {}", new Object[]{key, e, mapping});
            }
        }
        logger.info("Loading default Kibana mapping for {} from plugin: {}", new Object[]{key, keyDefault});
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            return IOUtils.toString((InputStream)classLoader.getResourceAsStream(keyDefault));
        }
        catch (Exception e) {
            logger.error("Unable to load the Kibana mapping specified by {}: {}", new Object[]{key, e, keyDefault});
            return null;
        }
    }

    public String getApplicationMappingsTemplate() {
        return this.appMappingsTemplate;
    }

    public String getOperationsMappingsTemplate() {
        return this.opsMappingsTemplate;
    }

    public String getEmptyProjectMappingsTemplate() {
        return this.emptyProjectMappingsTemplate;
    }
}

