/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.plugin.acl.RoleBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SearchGuardRoles
implements Iterable<Roles>,
ConfigurationSettings {
    public static final String ROLE_PREFIX = "gen";
    public static final String PROJECT_PREFIX = "gen_project";
    private static final String[] DEFAULT_ROLE_ACTIONS = new String[]{"indices:data/read*", "indices:admin/mappings/fields/get*", "indices:admin/validate/query*", "indices:admin/get*"};
    private static final String[] KIBANA_INDEX_ACTIONS = new String[]{"indices:*"};
    private static final String[] DEFAULT_CLUSTER_ACTIONS = new String[]{"cluster:monitor/nodes/info", "cluster:monitor/health"};
    private static final String DEFAULT_ROLE_TYPE = "*";
    private static final String DEFAULT_ROLE_INDEX = "*";
    private static final String CLUSTER_HEADER = "cluster";
    private static final String INDICES_HEADER = "indices";
    private List<Roles> roles;

    @Override
    public Iterator<Roles> iterator() {
        return new ArrayList<Roles>(this.roles).iterator();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void removeRole(Roles role) {
        this.roles.remove(role);
    }

    public void syncFrom(UserProjectCache cache, String userProfilePrefix, String cdmProjectPrefix) {
        this.removeSyncAcls();
        RolesBuilder builder = new RolesBuilder();
        for (String string : cache.getAllProjects()) {
            String projectName = String.format("%s_%s", PROJECT_PREFIX, string.replace('.', '_'));
            String indexName = String.format("%s?*", string.replace('.', '?'));
            RoleBuilder role = new RoleBuilder(projectName).setActions(indexName, "*", DEFAULT_ROLE_ACTIONS);
            if (StringUtils.isNotEmpty((String)cdmProjectPrefix)) {
                indexName = String.format("%s?%s?*", cdmProjectPrefix.replace('.', '?'), string.replace('.', '?'));
                role.setActions(indexName, "*", DEFAULT_ROLE_ACTIONS);
            }
            builder.addRole(role.build());
        }
        for (Map.Entry entry : cache.getUserProjects().entrySet()) {
            String usernameHash = KibanaUserReindexFilter.getUsernameHash((String)((AbstractMap.SimpleImmutableEntry)entry.getKey()).getKey());
            String projectName = String.format("%s_%s_%s", ROLE_PREFIX, "kibana", usernameHash);
            String indexName = String.format("%s?%s", userProfilePrefix.replace('.', '?'), usernameHash);
            RoleBuilder role = new RoleBuilder(projectName).setActions(indexName, "*", KIBANA_INDEX_ACTIONS);
            builder.addRole(role.build());
        }
        this.roles.addAll(builder.build());
    }

    private void removeSyncAcls() {
        for (Roles role : new ArrayList<Roles>(this.roles)) {
            if (role.getName() == null || !role.getName().startsWith(ROLE_PREFIX)) continue;
            this.removeRole(role);
        }
    }

    public SearchGuardRoles load(Map<String, Object> source) {
        RolesBuilder builder = new RolesBuilder();
        for (String key : source.keySet()) {
            RoleBuilder roleBuilder = new RoleBuilder(key);
            HashMap role = (HashMap)source.get(key);
            ArrayList cluster = (ArrayList)role.get(CLUSTER_HEADER);
            roleBuilder.setClusters(cluster);
            HashMap indices = (HashMap)role.get(INDICES_HEADER);
            for (String index : indices.keySet()) {
                for (String type : ((HashMap)indices.get(index)).keySet()) {
                    List actions = (List)((HashMap)indices.get(index)).get(type);
                    roleBuilder.setActions(index, type, actions);
                }
            }
            builder.addRole(roleBuilder.build());
        }
        this.roles = builder.build();
        return this;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (Roles role : this.roles) {
            HashMap<String, Object> roleObject = new HashMap<String, Object>();
            HashMap indexObject = new HashMap();
            for (Roles.Indices index : role.getIndices()) {
                HashMap<String, List<String>> typeObject = new HashMap<String, List<String>>();
                for (Roles.Indices.Type type : index.getTypes()) {
                    typeObject.put(type.getType(), type.getActions());
                }
                indexObject.put(index.getIndex(), typeObject);
            }
            roleObject.put(INDICES_HEADER, indexObject);
            roleObject.put(CLUSTER_HEADER, role.getCluster());
            output.put(role.getName(), roleObject);
        }
        return output;
    }

    public static class Roles {
        private String name;
        private List<String> cluster;
        private List<Indices> indices;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getCluster() {
            return this.cluster;
        }

        public void setCluster(List<String> cluster) {
            this.cluster = cluster;
        }

        public List<Indices> getIndices() {
            return this.indices;
        }

        public void setIndices(List<Indices> indices) {
            this.indices = indices;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public static class Indices {
            private String index;
            private List<Type> types;

            public String getIndex() {
                return this.index;
            }

            public void setIndex(String index) {
                this.index = index;
            }

            public List<Type> getTypes() {
                return this.types;
            }

            public void setTypes(List<Type> types) {
                this.types = types;
            }

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            }

            public static class Type {
                private String type;
                private List<String> actions;

                public String getType() {
                    return this.type;
                }

                public void setType(String type) {
                    this.type = type;
                }

                public List<String> getActions() {
                    return this.actions;
                }

                public void setActions(List<String> actions) {
                    this.actions = actions;
                }

                public String toString() {
                    return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
                }
            }
        }
    }
}

