/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import com.floragunn.searchguard.SearchGuardPlugin;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.UserProjectCache;
import io.fabric8.elasticsearch.plugin.kibana.KibanaSeed;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.ConnectTransportException;

public class DynamicACLFilter
extends RestFilter
implements ConfigurationSettings {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final ESLogger logger;
    private final UserProjectCache cache;
    private final String proxyUserHeader;
    private final TransportClient esClient;
    private final String searchGuardIndex;
    private final String kibanaIndex;
    private final String kibanaVersion;
    private final String userProfilePrefix;
    private final Settings settings;
    private final ReentrantLock lock = new ReentrantLock();
    private final String kbnVersionHeader;
    private final String[] operationsProjects;
    private Boolean enabled;
    private final String cdmProjectPrefix;
    private KibanaSeed kibanaSeed;

    @Inject
    public DynamicACLFilter(UserProjectCache cache, Settings settings, Client client, KibanaSeed seed) {
        this.cache = cache;
        this.kibanaSeed = seed;
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
        this.proxyUserHeader = settings.get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
        this.searchGuardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.userProfilePrefix = settings.get("io.fabric8.elasticsearch.acl.user_profile_prefix", ".kibana");
        this.kibanaIndex = settings.get("kibana.config_index_name", ".kibana");
        this.kibanaVersion = settings.get("kibana.version", "4.5.1");
        this.kbnVersionHeader = settings.get("kibana.version.header", "kbn-version");
        this.operationsProjects = settings.getAsArray("openshift.operations.project.names", DEFAULT_OPENSHIFT_OPS_PROJECTS);
        this.cdmProjectPrefix = settings.get("openshift.config.project_index_prefix", "");
        this.logger.debug("searchGuardIndex: {}", new Object[]{this.searchGuardIndex});
        this.settings = settings;
        this.enabled = settings.getAsBoolean("openshift.acl.dynamic.enabled", Boolean.valueOf(true));
        System.setProperty("sg.nowarn.client", "true");
        String clusterName = settings.get("cluster.name");
        String keystore = settings.get("openshift.searchguard.keystore.path", "/usr/share/elasticsearch/config/admin.jks");
        String truststore = settings.get("openshift.searchguard.truststore.path", "/usr/share/elasticsearch/config/logging-es.truststore.jks");
        String kspass = settings.get("openshift.searchguard.keystore.password", "kspass");
        String tspass = settings.get("openshift.searchguard.truststore.password", "tspass");
        String kstype = settings.get("openshift.searchguard.keystore.type", "JKS");
        String tstype = settings.get("openshift.searchguard.truststore.type", "JKS");
        Settings.Builder settingsBuilder = Settings.builder().put("path.home", ".").put("path.conf", ".").put("searchguard.ssl.transport.keystore_filepath", keystore).put("searchguard.ssl.transport.truststore_filepath", truststore).put("searchguard.ssl.transport.keystore_password", kspass).put("searchguard.ssl.transport.truststore_password", tspass).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_type", kstype).put("searchguard.ssl.transport.truststore_type", tstype).put("cluster.name", clusterName).put("client.transport.ignore_cluster_name", false).put("client.transport.sniff", false);
        Settings clientSettings = settingsBuilder.build();
        this.esClient = TransportClient.builder().settings(clientSettings).addPlugin(SearchGuardSSLPlugin.class).addPlugin(SearchGuardPlugin.class).build();
        try {
            this.esClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress("localhost", 9300)));
        }
        catch (ConnectTransportException e) {
            this.logger.warn("Cluster may still be initializing. Please be patient: {}", new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RestRequest request, RestChannel channel, RestFilterChain chain) throws Exception {
        boolean continueProcessing = true;
        try {
            if (this.enabled.booleanValue()) {
                String kbnVersion = this.getKibanaVersion(request);
                if (StringUtils.isEmpty((String)kbnVersion)) {
                    kbnVersion = this.kibanaVersion;
                }
                String user = this.getUser(request);
                String token = this.getBearerToken(request);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Handling Request... {}", new Object[]{request.uri()});
                    this.logger.debug("Evaluating request for user '{}' with a {} token", new Object[]{user, StringUtils.isNotEmpty((String)token) ? "non-empty" : "empty"});
                    this.logger.debug("Cache has user: {}", new Object[]{this.cache.hasUser(user, token)});
                }
                if (StringUtils.isNotEmpty((String)token) && StringUtils.isNotEmpty((String)user) && !this.cache.hasUser(user, token)) {
                    boolean isOperationsUser = this.isOperationsUser(user, token);
                    if (isOperationsUser) {
                        request.putInContext((Object)"X-OpenShift-Roles", (Object)"cluster-admin");
                    }
                    if (this.updateCache(user, token, isOperationsUser, kbnVersion)) {
                        this.syncAcl();
                    }
                }
            }
        }
        catch (ElasticsearchSecurityException ese) {
            this.logger.info("Could not authenticate user", new Object[0]);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED));
            continueProcessing = false;
        }
        catch (Exception e) {
            this.logger.error("Error handling request in {}", (Throwable)e, new Object[]{this.getClass().getSimpleName()});
        }
        finally {
            if (continueProcessing) {
                chain.continueProcessing(request, channel);
            }
        }
    }

    private String getUser(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.proxyUserHeader), (Object)"");
    }

    private String getBearerToken(RestRequest request) {
        String[] auth = ((String)ObjectUtils.defaultIfNull((Object)request.header(AUTHORIZATION_HEADER), (Object)"")).split(" ");
        if (auth.length >= 2 && "Bearer".equals(auth[0])) {
            return auth[1];
        }
        return "";
    }

    private String getKibanaVersion(RestRequest request) {
        return (String)ObjectUtils.defaultIfNull((Object)request.header(this.kbnVersionHeader), (Object)"");
    }

    private boolean updateCache(String user, String token, boolean isOperationsUser, String kbnVersion) {
        this.logger.debug("Updating the cache for user '{}'", new Object[]{user});
        try {
            Set<String> projects = this.listProjectsFor(token);
            this.cache.update(user, token, projects, isOperationsUser);
            HashSet<String> roles = new HashSet<String>();
            if (isOperationsUser) {
                roles.add("operations-user");
            }
            this.kibanaSeed.setDashboards(user, projects, roles, (Client)this.esClient, this.kibanaIndex, kbnVersion, this.cdmProjectPrefix, this.settings);
        }
        catch (KubernetesClientException e) {
            this.logger.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
            throw new ElasticsearchSecurityException(e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving project list for '{}'", (Throwable)e, new Object[]{user});
            return false;
        }
        return true;
    }

    private Set<String> listProjectsFor(String token) throws Exception {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        HashSet<String> names = new HashSet<String>();
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient(builder.build());){
            List projects = ((ProjectList)client.projects().list()).getItems();
            for (Project project : projects) {
                if (this.isBlacklistProject(project.getMetadata().getName())) continue;
                names.add(project.getMetadata().getName() + "." + project.getMetadata().getUid());
            }
        }
        return names;
    }

    private boolean isBlacklistProject(String project) {
        return ArrayUtils.contains((Object[])this.operationsProjects, (Object)project.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOperationsUser(String user, String token) {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
        boolean allowed = false;
        try (DefaultOpenShiftClient osClient = new DefaultOpenShiftClient(builder.build());){
            this.logger.debug("Submitting a SAR to see if '{}' is able to retrieve logs across the cluster", new Object[]{user});
            SubjectAccessReviewResponse response = (SubjectAccessReviewResponse)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((NamespacedOpenShiftClient)osClient.inAnyNamespace()).subjectAccessReviews().createNew()).withVerb("get")).withResource("pods/log")).done();
            allowed = response.getAllowed();
        }
        catch (Exception e) {
            try {
                this.logger.error("Exception determining user's '{}' role.", (Throwable)e, new Object[]{user});
            }
            catch (Throwable throwable) {
                this.logger.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
                throw throwable;
            }
            this.logger.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
        }
        this.logger.debug("User '{}' isOperationsUser: {}", new Object[]{user, allowed});
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAcl() {
        this.logger.debug("Syncing the ACL to ElasticSearch", new Object[0]);
        try {
            this.lock.lock();
            this.logger.debug("Loading SearchGuard ACL...", new Object[0]);
            SearchGuardRoles roles = this.readRolesACL((Client)this.esClient);
            SearchGuardRolesMapping rolesMapping = this.readRolesMappingACL((Client)this.esClient);
            this.logger.debug("Syncing from cache to ACL...", new Object[0]);
            roles.syncFrom(this.cache, this.userProfilePrefix, this.cdmProjectPrefix);
            rolesMapping.syncFrom(this.cache, this.userProfilePrefix);
            this.writeACL((Client)this.esClient, roles, rolesMapping);
        }
        catch (Exception e) {
            this.logger.error("Exception while syncing ACL with cache", (Throwable)e, new Object[0]);
        }
        finally {
            this.lock.unlock();
        }
    }

    private SearchGuardRoles readRolesACL(Client esClient) throws IOException {
        GetRequest getRequest = (GetRequest)esClient.prepareGet(this.searchGuardIndex, "roles", "0").setRefresh(true).request();
        GetResponse response = (GetResponse)esClient.get(getRequest).actionGet();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Read in roles {}", new Object[]{XContentHelper.convertToJson((BytesReference)response.getSourceAsBytesRef(), (boolean)true, (boolean)true)});
        }
        return new SearchGuardRoles().load(response.getSource());
    }

    private SearchGuardRolesMapping readRolesMappingACL(Client esClient) throws IOException {
        GetRequest getRequest = (GetRequest)esClient.prepareGet(this.searchGuardIndex, "rolesmapping", "0").setRefresh(true).request();
        GetResponse response = (GetResponse)esClient.get(getRequest).actionGet();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Read in rolesMapping {}", new Object[]{XContentHelper.convertToJson((BytesReference)response.getSourceAsBytesRef(), (boolean)true, (boolean)true)});
        }
        return new SearchGuardRolesMapping().load(response.getSource());
    }

    private void writeACL(Client esClient, SearchGuardRoles roles, SearchGuardRolesMapping rolesMapping) throws IOException {
        IndexRequest rolesIR = ((IndexRequest)new IndexRequest(this.searchGuardIndex).type("roles").id("0").refresh(true).consistencyLevel(WriteConsistencyLevel.DEFAULT)).source(roles.toMap());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Built roles request: {}", new Object[]{XContentHelper.convertToJson((BytesReference)rolesIR.source(), (boolean)true, (boolean)true)});
        }
        String rolesID = ((IndexResponse)esClient.index(rolesIR).actionGet()).getId();
        this.logger.debug("Roles ID: '{}'", new Object[]{rolesID});
        IndexRequest mappingIR = ((IndexRequest)new IndexRequest(this.searchGuardIndex).type("rolesmapping").id("0").refresh(true).consistencyLevel(WriteConsistencyLevel.DEFAULT)).source(rolesMapping.toMap());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Built rolesMapping request: {}", new Object[]{XContentHelper.convertToJson((BytesReference)mappingIR.source(), (boolean)true, (boolean)true)});
        }
        String rmID = ((IndexResponse)esClient.index(mappingIR).actionGet()).getId();
        this.logger.debug("rolesMapping ID: '{}'", new Object[]{rmID});
        ConfigUpdateResponse cur = (ConfigUpdateResponse)esClient.execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)new ConfigUpdateRequest(SEARCHGUARD_INITIAL_CONFIGS)).actionGet();
        if (((ConfigUpdateResponse.Node[])cur.getNodes()).length > 0) {
            this.logger.debug("Successfully reloaded config with '{}' nodes", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length});
        } else {
            this.logger.warn("Failed to reloaded configs", new Object[]{((ConfigUpdateResponse.Node[])cur.getNodes()).length});
        }
    }

    public int order() {
        return Integer.MIN_VALUE;
    }
}

