/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.tools;

import com.floragunn.searchguard.crypto.BCrypt;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Hasher {
    public static void main(String[] args) {
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        options.addOption(Option.builder((String)"p").argName("password").hasArg().desc("Cleartext password to hash").required().build());
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            System.out.println(Hasher.hash(line.getOptionValue("p").getBytes("UTF-8")));
        }
        catch (Exception exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            formatter.printHelp("hasher.sh", options, true);
        }
    }

    public static String hash(byte[] clearTextPassword) {
        return BCrypt.hashpw(Objects.requireNonNull(clearTextPassword), BCrypt.gensalt(12));
    }
}

