/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ImageLayer;
import io.fabric8.openshift.api.model.ImageLayerBuilder;
import io.fabric8.openshift.api.model.ImageLayerFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ImageFluentImpl<A extends ImageFluent<A>>
extends BaseFluent<A>
implements ImageFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends ImageLayer, ?>> dockerImageLayers = new ArrayList();
    private String dockerImageManifest;
    private HasMetadata dockerImageMetadata;
    private String dockerImageMetadataVersion;
    private String dockerImageReference;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;

    public ImageFluentImpl() {
    }

    public ImageFluentImpl(Image instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDockerImageLayers(instance.getDockerImageLayers());
        this.withDockerImageManifest(instance.getDockerImageManifest());
        this.withDockerImageMetadata(instance.getDockerImageMetadata());
        this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToDockerImageLayers(ImageLayer ... items) {
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.add(builder);
            this.dockerImageLayers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDockerImageLayers(ImageLayer ... items) {
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.remove(builder);
            this.dockerImageLayers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ImageLayer> getDockerImageLayers() {
        return ImageFluentImpl.build(this.dockerImageLayers);
    }

    @Override
    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers) {
        this.dockerImageLayers.clear();
        if (dockerImageLayers != null) {
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDockerImageLayers(ImageLayer ... dockerImageLayers) {
        this.dockerImageLayers.clear();
        if (dockerImageLayers != null) {
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer() {
        return new DockerImageLayersNestedImpl();
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item) {
        return new DockerImageLayersNestedImpl(item);
    }

    @Override
    public A addNewDockerImageLayer(String name, Long size) {
        return this.addToDockerImageLayers(new ImageLayer(name, size));
    }

    @Override
    public String getDockerImageManifest() {
        return this.dockerImageManifest;
    }

    @Override
    public A withDockerImageManifest(String dockerImageManifest) {
        this.dockerImageManifest = dockerImageManifest;
        return (A)this;
    }

    @Override
    public HasMetadata getDockerImageMetadata() {
        return this.dockerImageMetadata;
    }

    @Override
    public A withDockerImageMetadata(HasMetadata dockerImageMetadata) {
        this.dockerImageMetadata = dockerImageMetadata;
        return (A)this;
    }

    @Override
    public String getDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion;
    }

    @Override
    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion) {
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
        return (A)this;
    }

    @Override
    public String getDockerImageReference() {
        return this.dockerImageReference;
    }

    @Override
    public A withDockerImageReference(String dockerImageReference) {
        this.dockerImageReference = dockerImageReference;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ImageFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageFluentImpl that = (ImageFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dockerImageLayers != null ? !this.dockerImageLayers.equals(that.dockerImageLayers) : that.dockerImageLayers != null) {
            return false;
        }
        if (this.dockerImageManifest != null ? !this.dockerImageManifest.equals(that.dockerImageManifest) : that.dockerImageManifest != null) {
            return false;
        }
        if (this.dockerImageMetadata != null && this.dockerImageMetadata != this ? !this.dockerImageMetadata.equals(that.dockerImageMetadata) : that.dockerImageMetadata != null && this.dockerImageMetadata != this) {
            return false;
        }
        if (this.dockerImageMetadataVersion != null ? !this.dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) : that.dockerImageMetadataVersion != null) {
            return false;
        }
        if (this.dockerImageReference != null ? !this.dockerImageReference.equals(that.dockerImageReference) : that.dockerImageReference != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageFluent.MetadataNested<N>>
    implements ImageFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class DockerImageLayersNestedImpl<N>
    extends ImageLayerFluentImpl<ImageFluent.DockerImageLayersNested<N>>
    implements ImageFluent.DockerImageLayersNested<N>,
    Nested<N> {
        private final ImageLayerBuilder builder;

        DockerImageLayersNestedImpl() {
            this.builder = new ImageLayerBuilder(this);
        }

        DockerImageLayersNestedImpl(ImageLayer item) {
            this.builder = new ImageLayerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.addToDockerImageLayers(this.builder.build());
        }

        @Override
        public N endDockerImageLayer() {
            return this.and();
        }
    }
}

