/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.ActionGroupHolder;
import com.floragunn.searchguard.configuration.ConfigChangeListener;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.TransportRequest;

public class PrivilegesEvaluator
implements ConfigChangeListener {
    private static final Set<String> NULL_SET = Sets.newHashSet((Object[])new String[]{null});
    private final Set<String> DLSFLS = ImmutableSet.of((Object)"_dls_", (Object)"_fls_");
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private final ClusterService clusterService;
    private volatile Settings rolesMapping;
    private volatile Settings roles;
    private volatile Settings config;
    private final ActionGroupHolder ah;
    private final IndexNameExpressionResolver resolver;
    private final Map<Class<?>, Method> typeCache = Collections.synchronizedMap(new HashMap(100));
    private final Map<Class<?>, Method> typesCache = Collections.synchronizedMap(new HashMap(100));
    private final String[] deniedActionPatterns;
    private final AuditLog auditLog;
    private static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.lenientExpandOpen();
    private final String searchguardIndex;

    @Inject
    public PrivilegesEvaluator(ClusterService clusterService, TransportConfigUpdateAction tcua, ActionGroupHolder ah, IndexNameExpressionResolver resolver, AuditLog auditLog, Settings settings) {
        tcua.addConfigChangeListener("rolesmapping", this);
        tcua.addConfigChangeListener("roles", this);
        tcua.addConfigChangeListener("config", this);
        this.clusterService = clusterService;
        this.ah = ah;
        this.resolver = resolver;
        this.auditLog = auditLog;
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        ArrayList<String> deniedActionPatternsList = new ArrayList<String>();
        deniedActionPatternsList.add("indices:data/write*");
        deniedActionPatternsList.add("indices:admin/close");
        deniedActionPatternsList.add("indices:admin/delete");
        this.deniedActionPatterns = deniedActionPatternsList.toArray(new String[0]);
    }

    @Override
    public void onChange(String event, Settings settings) {
        switch (event) {
            case "roles": {
                this.roles = settings;
                break;
            }
            case "rolesmapping": {
                this.rolesMapping = settings;
                break;
            }
            case "config": {
                this.config = settings;
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.rolesMapping != null && this.roles != null;
    }

    @Override
    public void validate(String event, Settings settings) throws ElasticsearchSecurityException {
    }

    public boolean evaluate(User user, String action, ActionRequest<?> request) {
        if (action.startsWith("cluster:admin/snapshot/restore")) {
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request);
            this.log.warn(action + " is not allowed for a regular user", new Object[0]);
            return false;
        }
        TransportAddress caller = Objects.requireNonNull((TransportAddress)request.getFromContext((Object)"_sg_remote_address"));
        if (this.log.isDebugEnabled()) {
            this.log.debug("evaluate permissions for {}", new Object[]{user});
            this.log.debug("requested {} from {}", new Object[]{action, caller});
        }
        ClusterState clusterState = this.clusterService.state();
        MetaData metaData = clusterState.metaData();
        Tuple<Set<String>, Set<String>> requestedResolvedAliasesIndicesTypes = this.resolve(user, action, (TransportRequest)request, metaData);
        Set<String> requestedResolvedIndices = Collections.unmodifiableSet((Set)requestedResolvedAliasesIndicesTypes.v1());
        HashSet<IndexType> requestedResolvedIndexTypes0 = new HashSet<IndexType>(((Set)requestedResolvedAliasesIndicesTypes.v1()).size() * ((Set)requestedResolvedAliasesIndicesTypes.v2()).size());
        for (String index : (Set)requestedResolvedAliasesIndicesTypes.v1()) {
            for (String type : (Set)requestedResolvedAliasesIndicesTypes.v2()) {
                requestedResolvedIndexTypes0.add(new IndexType(index, type));
            }
        }
        Set<IndexType> requestedResolvedIndexTypes = Collections.unmodifiableSet(requestedResolvedIndexTypes0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("requested resolved indextypes: {}", new Object[]{requestedResolvedIndexTypes});
        }
        if (requestedResolvedIndices.contains(this.searchguardIndex) && WildcardMatcher.matchAny(this.deniedActionPatterns, action)) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action);
            this.log.warn(action + " for '{}' index is not allowed for a regular user", new Object[]{this.searchguardIndex});
            return false;
        }
        if (requestedResolvedIndices.contains("_all") && WildcardMatcher.matchAny(this.deniedActionPatterns, action)) {
            this.auditLog.logSgIndexAttempt((TransportRequest)request, action);
            this.log.warn(action + " for '_all' indices is not allowed for a regular user", new Object[0]);
            return false;
        }
        if (requestedResolvedIndices.contains(this.searchguardIndex) || requestedResolvedIndices.contains("_all")) {
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).requestCache(Boolean.FALSE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable search request cache for this request", new Object[0]);
                }
            }
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Disable realtime for this request", new Object[0]);
                }
            }
        }
        Set<String> sgRoles = this.mapSgRoles(user, caller);
        if (this.log.isDebugEnabled()) {
            this.log.debug("mapped roles: {}", new Object[]{sgRoles});
        }
        boolean allowAction = false;
        HashMap dlsQueries = new HashMap();
        HashMap flsFields = new HashMap();
        for (String sgRole : sgRoles) {
            Settings sgRoleSettings = this.roles.getByPrefix(sgRole);
            if (sgRoleSettings.names().isEmpty()) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("sg_role {} is empty", new Object[]{sgRole});
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("---------- evaluate sg_role: {}", new Object[]{sgRole});
            }
            boolean compositeEnabled = this.config.getAsBoolean("searchguard.dynamic.composite_enabled", Boolean.valueOf(false));
            if (action.startsWith("cluster:") || action.startsWith("indices:admin/template/delete") || action.startsWith("indices:admin/template/get") || action.startsWith("indices:admin/template/put") || action.startsWith("indices:data/read/scroll") || compositeEnabled && action.equals("indices:data/write/bulk") || compositeEnabled && action.equals("indices:admin/aliases") || compositeEnabled && action.equals("indices:data/read/mget") || compositeEnabled && action.equals("indices:data/read/mpercolate") || compositeEnabled && action.equals("indices:data/read/msearch") || compositeEnabled && action.equals("indices:data/read/mtv") || compositeEnabled && action.equals("indices:data/read/coordinate-msearch")) {
                Set<String> resolvedActions = this.resolveActions(sgRoleSettings.getAsArray(".cluster", new String[0]));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  resolved cluster actions:{}", new Object[]{resolvedActions});
                }
                if (WildcardMatcher.matchAny(resolvedActions.toArray(new String[0]), action)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("  found a match for '{}' and {}, skip other roles", new Object[]{sgRole, action});
                    }
                    return true;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("  not match found a match for '{}' and {}, check next role", new Object[]{sgRole, action});
                continue;
            }
            Map permittedAliasesIndices0 = sgRoleSettings.getGroups(".indices");
            HashMap<String, Settings> permittedAliasesIndices = new HashMap<String, Settings>(permittedAliasesIndices0.size());
            for (String origKey : permittedAliasesIndices0.keySet()) {
                permittedAliasesIndices.put(origKey.replace("${user.name}", user.getName()).replace("${user_name}", user.getName()), (Settings)permittedAliasesIndices0.get(origKey));
            }
            ListMultimap resolvedRoleIndices = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
            HashSet<IndexType> _requestedResolvedIndexTypes = new HashSet<IndexType>(requestedResolvedIndexTypes);
            for (String permittedAliasesIndex : permittedAliasesIndices.keySet()) {
                if (WildcardMatcher.containsWildcard(permittedAliasesIndex)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("  Try wildcard match for {}", new Object[]{permittedAliasesIndex});
                    }
                    this.handleIndicesWithWildcard(action, permittedAliasesIndex, permittedAliasesIndices, requestedResolvedIndexTypes, _requestedResolvedIndexTypes, requestedResolvedIndices);
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("  Resolve and match {}", new Object[]{permittedAliasesIndex});
                    }
                    this.handleIndicesWithoutWildcard(action, permittedAliasesIndex, permittedAliasesIndices, requestedResolvedIndexTypes, _requestedResolvedIndexTypes);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("For index {} remaining requested indextype: {}", new Object[]{permittedAliasesIndex, _requestedResolvedIndexTypes});
                }
                if (!_requestedResolvedIndexTypes.isEmpty()) continue;
                int filteredAliasCount = 0;
                for (String requestAliasOrIndex : requestedResolvedIndices) {
                    IndexMetaData indexMetaData = (IndexMetaData)clusterState.metaData().getIndices().get((Object)requestAliasOrIndex);
                    if (indexMetaData == null) {
                        this.log.warn("{} does not exist in cluster metadata", new Object[]{requestAliasOrIndex});
                        continue;
                    }
                    ImmutableOpenMap aliases = indexMetaData.getAliases();
                    this.log.debug("Aliases for {}: {}", new Object[]{requestAliasOrIndex, aliases});
                    if (aliases == null || aliases.size() <= 0) continue;
                    UnmodifiableIterator it = aliases.keysIt();
                    while (it.hasNext()) {
                        String a = (String)it.next();
                        AliasMetaData aliasMetaData = (AliasMetaData)aliases.get((Object)a);
                        if (aliasMetaData != null && aliasMetaData.filteringRequired()) {
                            ++filteredAliasCount;
                            this.log.debug(a + " is a filtered alias " + aliasMetaData.getFilter(), new Object[0]);
                            continue;
                        }
                        this.log.debug(a + " is not an alias or does not have a filter", new Object[0]);
                    }
                }
                if (filteredAliasCount > 1) {
                    this.log.warn("More than one ({}) filtered alias found for same index ({}). This is currently not supported", new Object[]{filteredAliasCount, permittedAliasesIndex});
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("found a match for '{}.{}', evaluate other roles", new Object[]{sgRole, permittedAliasesIndex});
                }
                resolvedRoleIndices.put((Object)sgRole, (Object)permittedAliasesIndex);
            }
            if (resolvedRoleIndices.isEmpty()) continue;
            for (String resolvedRole : resolvedRoleIndices.keySet()) {
                for (String indexPattern : resolvedRoleIndices.get((Object)resolvedRole)) {
                    String ci;
                    int i;
                    String dls = this.roles.get(resolvedRole + ".indices." + indexPattern + "._dls_");
                    Object[] fls = this.roles.getAsArray(resolvedRole + ".indices." + indexPattern + "._fls_");
                    Object[] concreteIndices = new String[]{};
                    if (dls != null && dls.length() > 0 || fls != null && fls.length > 0) {
                        concreteIndices = this.resolver.concreteIndices(this.clusterService.state(), DEFAULT_INDICES_OPTIONS, new String[]{indexPattern});
                    }
                    if (dls != null && dls.length() > 0) {
                        dls = dls.replace("${user.name}", user.getName()).replace("${user_name}", user.getName());
                        for (i = 0; i < concreteIndices.length; ++i) {
                            ci = concreteIndices[i];
                            if (dlsQueries.containsKey(ci)) {
                                ((Set)dlsQueries.get(ci)).add(dls);
                                continue;
                            }
                            dlsQueries.put(ci, new HashSet());
                            ((Set)dlsQueries.get(ci)).add(dls);
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("dls query {} for {}", new Object[]{dls, Arrays.toString(concreteIndices)});
                        }
                    }
                    if (fls == null || fls.length <= 0) continue;
                    for (i = 0; i < concreteIndices.length; ++i) {
                        ci = concreteIndices[i];
                        if (flsFields.containsKey(ci)) {
                            ((Set)flsFields.get(ci)).addAll(Sets.newHashSet((Object[])fls));
                            continue;
                        }
                        flsFields.put(ci, new HashSet());
                        ((Set)flsFields.get(ci)).addAll(Sets.newHashSet((Object[])fls));
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("fls fields {} for {}", new Object[]{Sets.newHashSet((Object[])fls), Arrays.toString(concreteIndices)});
                }
            }
            allowAction = true;
        }
        if (!allowAction && this.log.isInfoEnabled()) {
            this.log.info("No perm match for {} {} [Action [{}]] [RolesChecked {}]", new Object[]{user, requestedResolvedIndexTypes, action, sgRoles});
        }
        if (!dlsQueries.isEmpty()) {
            request.putHeader("_sg_dls_query", (Object)Base64Helper.serializeObject(dlsQueries));
        }
        if (!flsFields.isEmpty()) {
            request.putHeader("_sg_fls_fields", (Object)Base64Helper.serializeObject(flsFields));
        }
        return allowAction;
    }

    public Set<String> mapSgRoles(User user, TransportAddress caller) {
        if (user == null) {
            return Collections.emptySet();
        }
        TreeSet<String> sgRoles = new TreeSet<String>();
        for (String roleMap : this.rolesMapping.names()) {
            Settings roleMapSettings = this.rolesMapping.getByPrefix(roleMap);
            if (WildcardMatcher.matchAny(roleMapSettings.getAsArray(".backendroles"), user.getRoles().toArray(new String[0]))) {
                sgRoles.add(roleMap);
                continue;
            }
            if (WildcardMatcher.matchAny(roleMapSettings.getAsArray(".users"), user.getName())) {
                sgRoles.add(roleMap);
                continue;
            }
            if (caller != null && WildcardMatcher.matchAny(roleMapSettings.getAsArray(".hosts"), caller.getAddress())) {
                sgRoles.add(roleMap);
                continue;
            }
            if (caller == null || !WildcardMatcher.matchAny(roleMapSettings.getAsArray(".hosts"), caller.getHost())) continue;
            sgRoles.add(roleMap);
        }
        return Collections.unmodifiableSet(sgRoles);
    }

    private void handleIndicesWithWildcard(String action, String permittedAliasesIndex, Map<String, Settings> permittedAliasesIndices, Set<IndexType> requestedResolvedIndexTypes, Set<IndexType> _requestedResolvedIndexTypes, Set<String> requestedResolvedIndices0) {
        List<String> wi = null;
        wi = WildcardMatcher.getMatchAny(permittedAliasesIndex, requestedResolvedIndices0.toArray(new String[0]));
        if (!wi.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  Wildcard match for {}: {}", new Object[]{permittedAliasesIndex, wi});
            }
            HashSet permittedTypes = new HashSet(permittedAliasesIndices.get(permittedAliasesIndex).names());
            permittedTypes.removeAll(this.DLSFLS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("  matches for {}, will check now types {}", new Object[]{permittedAliasesIndex, permittedTypes});
            }
            for (String type : permittedTypes) {
                Set<String> resolvedActions = this.resolveActions(permittedAliasesIndices.get(permittedAliasesIndex).getAsArray(type));
                if (!WildcardMatcher.matchAny(resolvedActions.toArray(new String[0]), action)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("    match requested action {} against {}/{}: {}", new Object[]{action, permittedAliasesIndex, type, resolvedActions});
                }
                for (String it : wi) {
                    boolean removed = this.wildcardRemoveFromSet(_requestedResolvedIndexTypes, new IndexType(it, type));
                    if (removed) {
                        this.log.debug("    removed {}", new Object[]{it + type});
                        continue;
                    }
                    this.log.debug("    no match {} in {}", new Object[]{it + type, _requestedResolvedIndexTypes});
                }
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  No wildcard match found for {}", new Object[]{permittedAliasesIndex});
            }
            return;
        }
    }

    private void handleIndicesWithoutWildcard(String action, String permittedAliasesIndex, Map<String, Settings> permittedAliasesIndices, Set<IndexType> requestedResolvedIndexTypes, Set<IndexType> _requestedResolvedIndexTypes) {
        HashSet<String> resolvedPermittedAliasesIndex = new HashSet<String>();
        if (!this.resolver.hasIndexOrAlias(permittedAliasesIndex, this.clusterService.state())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("no permittedAliasesIndex '{}' found for  '{}'", new Object[]{permittedAliasesIndex, action});
                for (String pai : permittedAliasesIndices.keySet()) {
                    Settings paiSettings = permittedAliasesIndices.get(pai);
                    this.log.debug("permittedAliasesIndices '{}' -> '{}'", new Object[]{permittedAliasesIndices, paiSettings == null ? "null" : String.valueOf(paiSettings.getAsMap())});
                }
                this.log.debug("requestedResolvedIndexTypes '{}'", new Object[]{requestedResolvedIndexTypes});
            }
            resolvedPermittedAliasesIndex.add(permittedAliasesIndex);
        } else {
            resolvedPermittedAliasesIndex.addAll(Arrays.asList(this.resolver.concreteIndices(this.clusterService.state(), DEFAULT_INDICES_OPTIONS, new String[]{permittedAliasesIndex})));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("  resolved permitted aliases indices for {}: {}", new Object[]{permittedAliasesIndex, resolvedPermittedAliasesIndex});
        }
        HashSet permittedTypes = new HashSet(permittedAliasesIndices.get(permittedAliasesIndex).names());
        permittedTypes.removeAll(this.DLSFLS);
        if (this.log.isDebugEnabled()) {
            this.log.debug("  matches for {}, will check now types {}", new Object[]{permittedAliasesIndex, permittedTypes});
        }
        for (String type : permittedTypes) {
            Set<String> resolvedActions = this.resolveActions(permittedAliasesIndices.get(permittedAliasesIndex).getAsArray(type));
            if (!WildcardMatcher.matchAny(resolvedActions.toArray(new String[0]), action)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("    match requested action {} against {}/{}: {}", new Object[]{action, permittedAliasesIndex, type, resolvedActions});
            }
            for (String resolvedPermittedIndex : resolvedPermittedAliasesIndex) {
                boolean removed = this.wildcardRemoveFromSet(_requestedResolvedIndexTypes, new IndexType(resolvedPermittedIndex, type));
                if (removed) {
                    this.log.debug("    removed {}", new Object[]{resolvedPermittedIndex + type});
                    continue;
                }
                this.log.debug("    no match {} in {}", new Object[]{resolvedPermittedIndex + type, _requestedResolvedIndexTypes});
            }
        }
    }

    private Tuple<Set<String>, Set<String>> resolve(User user, String action, TransportRequest request, MetaData metaData) {
        if (!(request instanceof CompositeIndicesRequest) && !(request instanceof IndicesRequest)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} is not an IndicesRequest", new Object[]{request.getClass()});
            }
            return new Tuple((Object)Sets.newHashSet((Object[])new String[]{"_all"}), (Object)Sets.newHashSet((Object[])new String[]{"_all"}));
        }
        HashSet<String> indices = new HashSet<String>();
        HashSet<String> types = new HashSet<String>();
        if (request instanceof CompositeIndicesRequest) {
            for (IndicesRequest indicesRequest : ((CompositeIndicesRequest)request).subRequests()) {
                Tuple<Set<String>, Set<String>> t = this.resolve(user, action, indicesRequest, metaData);
                indices.addAll((Collection)t.v1());
                types.addAll((Collection)t.v2());
            }
        } else {
            Tuple<Set<String>, Set<String>> t = this.resolve(user, action, (IndicesRequest)request, metaData);
            indices.addAll((Collection)t.v1());
            types.addAll((Collection)t.v2());
        }
        if (IndexNameExpressionResolver.isAllIndices(new ArrayList(indices))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The following list are '_all' indices: {}", new Object[]{indices});
            }
            indices.clear();
            indices.add("_all");
        }
        if (types.isEmpty()) {
            types.add("_all");
        }
        return new Tuple(Collections.unmodifiableSet(indices), Collections.unmodifiableSet(types));
    }

    private Tuple<Set<String>, Set<String>> resolve(User user, String action, IndicesRequest request, MetaData metaData) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolve {} from {}", new Object[]{request.indices(), request.getClass()});
        }
        Class<?> requestClass = request.getClass();
        HashSet<String> requestTypes = new HashSet<String>();
        Method typeMethod = null;
        if (this.typeCache.containsKey(requestClass)) {
            typeMethod = this.typeCache.get(requestClass);
        } else {
            try {
                typeMethod = requestClass.getMethod("type", new Class[0]);
                this.typeCache.put(requestClass, typeMethod);
            }
            catch (NoSuchMethodException e) {
                this.typeCache.put(requestClass, null);
            }
            catch (SecurityException e) {
                this.log.error("Cannot evaluate type() for {} due to {}", new Object[]{requestClass, e});
            }
        }
        Method typesMethod = null;
        if (this.typesCache.containsKey(requestClass)) {
            typesMethod = this.typesCache.get(requestClass);
        } else {
            try {
                typesMethod = requestClass.getMethod("types", new Class[0]);
                this.typesCache.put(requestClass, typesMethod);
            }
            catch (NoSuchMethodException e) {
                this.typesCache.put(requestClass, null);
            }
            catch (SecurityException e) {
                this.log.error("Cannot evaluate types() for {} due to {}", new Object[]{requestClass, e});
            }
        }
        if (typeMethod != null) {
            try {
                String type = (String)typeMethod.invoke((Object)request, new Object[0]);
                if (type != null) {
                    requestTypes.add(type);
                }
            }
            catch (Exception e) {
                this.log.error("Unable to invoke type() for {} due to {}", (Throwable)e, new Object[]{requestClass, e});
            }
        }
        if (typesMethod != null) {
            try {
                String[] types = (String[])typesMethod.invoke((Object)request, new Object[0]);
                if (types != null) {
                    requestTypes.addAll(Arrays.asList(types));
                }
            }
            catch (Exception e) {
                this.log.error("Unable to invoke types() for {} due to {}", (Throwable)e, new Object[]{requestClass, e});
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("indicesOptions {}", new Object[]{request.indicesOptions()});
            this.log.debug("raw indices {}", new Object[]{Arrays.toString(request.indices())});
        }
        HashSet<String> indices = new HashSet<String>();
        if (request.indices() == null || request.indices().length == 0 || new HashSet<String>(Arrays.asList(request.indices())).equals(NULL_SET)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No indices found in request, assume _all", new Object[0]);
            }
            indices.addAll(Arrays.asList(this.resolver.concreteIndices(this.clusterService.state(), DEFAULT_INDICES_OPTIONS, new String[]{"*"})));
        } else {
            try {
                indices.addAll(Arrays.asList(this.resolver.concreteIndices(this.clusterService.state(), request)));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Resolved {} to {}", new Object[]{request.indices(), indices});
                }
            }
            catch (Exception e) {
                this.log.debug("Cannot resolve {} (due to {}) so we use the raw values", new Object[]{Arrays.toString(request.indices()), e});
                indices.addAll(Arrays.asList(request.indices()));
            }
        }
        return new Tuple(indices, requestTypes);
    }

    private Set<String> resolveActions(String[] actions) {
        HashSet<String> resolvedActions = new HashSet<String>();
        for (int i = 0; i < actions.length; ++i) {
            String string = actions[i];
            Set<String> groups = this.ah.getGroupMembers(string);
            if (groups.isEmpty()) {
                resolvedActions.add(string);
                continue;
            }
            resolvedActions.addAll(groups);
        }
        return resolvedActions;
    }

    private boolean wildcardRemoveFromSet(Set<IndexType> set, IndexType stringContainingWc) {
        if (set.contains(stringContainingWc)) {
            return set.remove(stringContainingWc);
        }
        boolean modified = false;
        HashSet<IndexType> copy = new HashSet<IndexType>(set);
        for (IndexType it : copy) {
            if (!WildcardMatcher.match(stringContainingWc.getCombinedString(), it.getCombinedString())) continue;
            modified = set.remove(it) | modified;
        }
        return modified;
    }

    private static class IndexType {
        private String index;
        private String type;

        public IndexType(String index, String type) {
            this.index = index;
            this.type = type.equals("_all") ? "*" : type;
        }

        public String getCombinedString() {
            return this.index + "#" + this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexType other = (IndexType)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "IndexType [index=" + this.index + ", type=" + this.type + "]";
        }
    }
}

