/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.configuration.ConfigCallback;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.JsonSettingsLoader;
import org.elasticsearch.common.xcontent.XContentHelper;

public class ConfigurationLoader {
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private final Provider<Client> client;
    private final String searchguardIndex;

    @Inject
    public ConfigurationLoader(Provider<Client> client, Settings settings) {
        this.client = client;
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.log.debug("Index is: {}", new Object[]{this.searchguardIndex});
    }

    public Map<String, Settings> load(final String[] events, long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        final CountDownLatch latch = new CountDownLatch(events.length);
        final HashMap<String, Settings> rs = new HashMap<String, Settings>(events.length);
        this.loadAsync(events, new ConfigCallback(){

            @Override
            public void success(String type, Settings settings) {
                if (latch.getCount() <= 0L) {
                    ConfigurationLoader.this.log.error("Latch already counted down (for {} of {})  (index={})", new Object[]{type, Arrays.toString(events), ConfigurationLoader.this.searchguardIndex});
                }
                rs.put(type, settings);
                latch.countDown();
                if (ConfigurationLoader.this.log.isDebugEnabled()) {
                    ConfigurationLoader.this.log.debug("Received config for {} (of {}) with current latch value={}", new Object[]{type, Arrays.toString(events), latch.getCount()});
                }
            }

            @Override
            public void singleFailure(MultiGetResponse.Failure failure) {
                ConfigurationLoader.this.log.error("Failure {} retrieving configuration for {} (index={})", new Object[]{failure == null ? null : failure.getMessage(), Arrays.toString(events), ConfigurationLoader.this.searchguardIndex});
            }

            @Override
            public void noData(String type) {
                ConfigurationLoader.this.log.error("No data for {} while retrieving configuration for {}  (index={})", new Object[]{type, Arrays.toString(events), ConfigurationLoader.this.searchguardIndex});
            }

            @Override
            public void failure(Throwable t) {
                ConfigurationLoader.this.log.error("Exception {} while retrieving configuration for {}  (index={})", t, new Object[]{t.toString(), Arrays.toString(events), ConfigurationLoader.this.searchguardIndex});
            }
        });
        if (!latch.await(timeout, timeUnit)) {
            throw new TimeoutException("Timeout after " + timeout + "" + (Object)((Object)timeUnit) + " while retrieving configuration for " + Arrays.toString(events) + "(index=" + this.searchguardIndex + ")");
        }
        return rs;
    }

    public void loadAsync(String[] events, final ConfigCallback callback) {
        if (events == null || events.length == 0) {
            this.log.warn("No config events requested to load", new Object[0]);
            return;
        }
        MultiGetRequest mget = new MultiGetRequest();
        for (int i = 0; i < events.length; ++i) {
            String event = events[i];
            mget.add(this.searchguardIndex, event, "0");
        }
        mget.putHeader("_sg_conf_request", (Object)"true");
        mget.refresh(true);
        mget.realtime(Boolean.valueOf(true));
        ((Client)this.client.get()).multiGet(mget, (ActionListener)new ActionListener<MultiGetResponse>(){

            public void onResponse(MultiGetResponse response) {
                MultiGetItemResponse[] responses = response.getResponses();
                for (int i = 0; i < responses.length; ++i) {
                    MultiGetItemResponse singleResponse = responses[i];
                    if (singleResponse != null && !singleResponse.isFailed()) {
                        GetResponse singleGetResponse = singleResponse.getResponse();
                        if (singleGetResponse.isExists() && !singleGetResponse.isSourceEmpty()) {
                            Settings _settings = ConfigurationLoader.this.toSettings(singleGetResponse.getSourceAsBytesRef(), singleGetResponse.getType());
                            if (_settings == null) continue;
                            callback.success(singleGetResponse.getType(), _settings);
                            continue;
                        }
                        callback.noData(singleGetResponse.getType());
                        continue;
                    }
                    callback.singleFailure(singleResponse == null ? null : singleResponse.getFailure());
                }
            }

            public void onFailure(Throwable e) {
                callback.failure(e);
            }
        });
    }

    private Settings toSettings(BytesReference ref, String type) {
        if (ref == null || ref.length() == 0) {
            this.log.error("Null or empty BytesReference for " + type, new Object[0]);
            return null;
        }
        try {
            return Settings.builder().put(new JsonSettingsLoader().load(XContentHelper.createParser((BytesReference)ref))).build();
        }
        catch (Exception e) {
            this.log.error("Unable to parse {} due to {}", (Throwable)e, new Object[]{type, e.toString()});
            return null;
        }
    }
}

