/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.rest;

import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import io.netty.handler.ssl.OpenSsl;
import java.security.cert.X509Certificate;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class SearchGuardSSLInfoAction
extends BaseRestHandler {
    private final SearchGuardKeyStore sgks;

    @Inject
    public SearchGuardSSLInfoAction(Settings settings, RestController controller, Client client, SearchGuardKeyStore sgks) {
        super(settings, controller, client);
        this.sgks = sgks;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/sslinfo", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        BytesRestResponse response = null;
        XContentBuilder builder = channel.newBuilder();
        try {
            X509Certificate[] certs = (X509Certificate[])request.getFromContext((Object)"_sg_ssl_peer_certificates");
            builder.startObject();
            builder.field("principal", (String)request.getFromContext((Object)"_sg_ssl_principal"));
            builder.field("peer_certificates", certs != null && certs.length > 0 ? certs.length + "" : "0");
            builder.field("ssl_protocol", (String)request.getFromContext((Object)"_sg_ssl_protocol"));
            builder.field("ssl_cipher", (String)request.getFromContext((Object)"_sg_ssl_cipher"));
            builder.field("ssl_openssl_available", OpenSsl.isAvailable());
            builder.field("ssl_openssl_version", OpenSsl.version());
            builder.field("ssl_openssl_version_string", OpenSsl.versionString());
            Throwable openSslUnavailCause = OpenSsl.unavailabilityCause();
            builder.field("ssl_openssl_non_available_cause", openSslUnavailCause == null ? "" : openSslUnavailCause.toString());
            builder.field("ssl_provider_http", this.sgks.getHTTPProviderName());
            builder.field("ssl_provider_transport_server", this.sgks.getTransportServerProviderName());
            builder.field("ssl_provider_transport_client", this.sgks.getTransportClientProviderName());
            builder.endObject();
            response = new BytesRestResponse(RestStatus.OK, builder);
        }
        catch (Exception e1) {
            this.logger.error("Error handle request " + e1, (Throwable)e1, new Object[0]);
            builder = channel.newBuilder();
            builder.startObject();
            builder.field("error", e1.toString());
            builder.endObject();
            response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
        }
        channel.sendResponse((RestResponse)response);
    }
}

