/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.configupdate;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.configuration.ConfigChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationLoader;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportConfigUpdateAction
extends TransportNodesAction<ConfigUpdateRequest, ConfigUpdateResponse, NodeConfigUpdateRequest, ConfigUpdateResponse.Node> {
    private final ClusterService clusterService;
    private final ConfigurationLoader cl;
    private final Provider<BackendRegistry> backendRegistry;
    private final ListMultimap<String, ConfigChangeListener> multimap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final String searchguardIndex;

    @Inject
    public TransportConfigUpdateAction(final Provider<Client> clientProvider, final Settings settings, ClusterName clusterName, ThreadPool threadPool, final ClusterService clusterService, TransportService transportService, final ConfigurationLoader cl, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Provider<BackendRegistry> backendRegistry) {
        super(settings, "cluster:admin/searchguard/config/update", clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ConfigUpdateRequest.class, NodeConfigUpdateRequest.class, "management");
        this.cl = cl;
        this.clusterService = clusterService;
        this.backendRegistry = backendRegistry;
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                final Thread ct = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Client client = (Client)clientProvider.get();
                            TransportConfigUpdateAction.this.logger.debug("Node started, try to initialize it. Wait for at least yellow cluster state....", new Object[0]);
                            ClusterHealthResponse response = null;
                            try {
                                response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{TransportConfigUpdateAction.this.searchguardIndex}).waitForYellowStatus()).actionGet();
                            }
                            catch (Exception e1) {
                                TransportConfigUpdateAction.this.logger.debug("Catched a {} but we just try again ...", new Object[]{e1.toString()});
                            }
                            while (response == null || response.isTimedOut() || response.getStatus() == ClusterHealthStatus.RED) {
                                TransportConfigUpdateAction.this.logger.warn("index '{}' not healthy yet, we try again ... (Reason: {})", new Object[]{TransportConfigUpdateAction.this.searchguardIndex, response == null ? "no response" : (response.isTimedOut() ? "timeout" : "other, maybe red cluster")});
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException e1) {
                                    // empty catch block
                                }
                                try {
                                    response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{TransportConfigUpdateAction.this.searchguardIndex}).waitForYellowStatus()).actionGet();
                                }
                                catch (Exception e1) {
                                    TransportConfigUpdateAction.this.logger.debug("Catched again a {} but we just try again ...", new Object[]{e1.toString()});
                                }
                            }
                            Map<String, Settings> setn = null;
                            while (setn == null || !setn.keySet().containsAll(Lists.newArrayList((Object[])new String[]{"config", "roles", "rolesmapping"}))) {
                                if (setn != null) {
                                    try {
                                        Thread.sleep(3000L);
                                    }
                                    catch (InterruptedException e) {
                                        Thread.currentThread().interrupt();
                                        TransportConfigUpdateAction.this.logger.debug("Thread was interrupted so we cancle initialization", new Object[0]);
                                        return;
                                    }
                                }
                                TransportConfigUpdateAction.this.logger.debug("Try to load config ...", new Object[0]);
                                try {
                                    setn = cl.load(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"}, 1L, TimeUnit.MINUTES);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    TransportConfigUpdateAction.this.logger.debug("Thread was interrupted so we cancle initialization", new Object[0]);
                                    return;
                                }
                                catch (TimeoutException e) {
                                    TransportConfigUpdateAction.this.logger.warn("Timeout, we just try again in a few seconds ... ", new Object[0]);
                                }
                            }
                            TransportConfigUpdateAction.this.logger.debug("Retrieved {} configs", new Object[]{setn.keySet()});
                            TransportConfigUpdateAction.this.logger.debug("Retrieved config on node startup and will now update config change listeners", new Object[0]);
                            for (String evt : setn.keySet()) {
                                for (ConfigChangeListener cl : new ArrayList(TransportConfigUpdateAction.this.multimap.get((Object)evt))) {
                                    Settings settings = setn.get(evt);
                                    if (settings == null) continue;
                                    cl.onChange(evt, settings);
                                    TransportConfigUpdateAction.this.logger.debug("Updated {} for {} due to initial configuration on node '{}'", new Object[]{evt, cl.getClass().getSimpleName(), clusterService.localNode().getName()});
                                }
                            }
                            TransportConfigUpdateAction.this.logger.info("Node '{}' initialized", new Object[]{clusterService.localNode().getName()});
                        }
                        catch (Exception e) {
                            TransportConfigUpdateAction.this.logger.error("Unexpected exception while initializing node " + e, (Throwable)e, new Object[0]);
                        }
                    }
                });
                TransportConfigUpdateAction.this.logger.info("Check if " + TransportConfigUpdateAction.this.searchguardIndex + " index exists ...", new Object[0]);
                try {
                    IndicesExistsRequest ier = (IndicesExistsRequest)new IndicesExistsRequest(new String[]{TransportConfigUpdateAction.this.searchguardIndex}).masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
                    ier.putHeader("_sg_conf_request", (Object)"true");
                    ((Client)clientProvider.get()).admin().indices().exists(ier, (ActionListener)new ActionListener<IndicesExistsResponse>(){

                        public void onResponse(IndicesExistsResponse response) {
                            if (response != null && response.isExists()) {
                                ct.start();
                            } else if (settings.getAsBoolean("action.master.force_local", Boolean.valueOf(false)).booleanValue() && settings.getByPrefix("tribe").getAsMap().size() > 0) {
                                TransportConfigUpdateAction.this.logger.info("{} index does not exist yet, but we are a tribe node. So we will load the config anyhow until we got it ...", new Object[]{TransportConfigUpdateAction.this.searchguardIndex});
                                ct.start();
                            } else {
                                TransportConfigUpdateAction.this.logger.info("{} index does not exist yet, so no need to load config on node startup. Use sgadmin to initialize cluster", new Object[]{TransportConfigUpdateAction.this.searchguardIndex});
                            }
                        }

                        public void onFailure(Throwable e) {
                            TransportConfigUpdateAction.this.logger.error("Failure while checking {} index {}", e, new Object[]{TransportConfigUpdateAction.this.searchguardIndex, e});
                            ct.start();
                        }
                    });
                }
                catch (Throwable e2) {
                    TransportConfigUpdateAction.this.logger.error("Failure while executing IndicesExistsRequest {}", e2, new Object[]{e2});
                    ct.start();
                }
            }
        });
    }

    protected ConfigUpdateResponse newResponse(ConfigUpdateRequest request, AtomicReferenceArray nodesResponses) {
        ArrayList nodes = Lists.newArrayList();
        for (int i = 0; i < nodesResponses.length(); ++i) {
            Object resp = nodesResponses.get(i);
            if (!(resp instanceof ConfigUpdateResponse.Node)) continue;
            nodes.add((ConfigUpdateResponse.Node)((Object)resp));
        }
        return new ConfigUpdateResponse(this.clusterName, nodes.toArray(new ConfigUpdateResponse.Node[nodes.size()]));
    }

    protected NodeConfigUpdateRequest newNodeRequest(String nodeId, ConfigUpdateRequest request) {
        return new NodeConfigUpdateRequest(nodeId, request);
    }

    protected ConfigUpdateResponse.Node newNodeResponse() {
        return new ConfigUpdateResponse.Node(this.clusterService.localNode(), new String[0], null);
    }

    protected ConfigUpdateResponse.Node nodeOperation(NodeConfigUpdateRequest request) {
        try {
            Map<String, Settings> setn = this.cl.load(request.request.getConfigTypes(), 30L, TimeUnit.SECONDS);
            this.logger.debug("Retrieved config ({}) due to config update request and will now update config change listeners", new Object[]{Arrays.toString(request.request.getConfigTypes())});
            ((BackendRegistry)this.backendRegistry.get()).invalidateCache();
            for (String evt : setn.keySet()) {
                for (ConfigChangeListener cl : new ArrayList(this.multimap.get((Object)evt))) {
                    Settings settings = setn.get(evt);
                    if (settings == null) continue;
                    cl.onChange(evt, settings);
                    this.logger.debug("Updated {} for {} due to node operation on node {}", new Object[]{evt, cl.getClass().getSimpleName(), this.clusterService.localNode().getName()});
                }
            }
            return new ConfigUpdateResponse.Node(this.clusterService.localNode(), setn.keySet().toArray(new String[0]), null);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            this.logger.debug("Thread was interrupted, we return just a empty response", new Object[0]);
            return new ConfigUpdateResponse.Node(this.clusterService.localNode(), new String[0], "Interrupted");
        }
        catch (TimeoutException e1) {
            this.logger.error("Timeout {}", (Throwable)e1, new Object[]{e1});
            return new ConfigUpdateResponse.Node(this.clusterService.localNode(), new String[0], "Timeout (" + e1 + ")");
        }
    }

    public void addConfigChangeListener(String event, ConfigChangeListener listener) {
        this.logger.debug("Add config listener {}", new Object[]{listener.getClass()});
        this.multimap.put((Object)event, (Object)listener);
    }

    protected boolean accumulateExceptions() {
        return false;
    }

    public static class NodeConfigUpdateRequest
    extends BaseNodeRequest {
        ConfigUpdateRequest request;

        public NodeConfigUpdateRequest() {
        }

        public NodeConfigUpdateRequest(String nodeId, ConfigUpdateRequest request) {
            super((BaseNodesRequest)request, nodeId);
            this.request = request;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new ConfigUpdateRequest();
            this.request.readFrom(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

