/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auditlog;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auditlog.NullAuditLog;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class AuditLogModule
extends AbstractModule {
    protected final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());

    protected void configure() {
        try {
            Class<?> auditLogImpl = Class.forName("com.floragunn.searchguard.auditlog.impl.AuditLogImpl");
            if (auditLogImpl == null) {
                throw new ClassNotFoundException();
            }
            this.bind(AuditLog.class).to(auditLogImpl).asEagerSingleton();
            this.log.info("Auditlog available ({})", new Object[]{auditLogImpl.getSimpleName()});
        }
        catch (ClassNotFoundException e) {
            this.bind(AuditLog.class).to(NullAuditLog.class).asEagerSingleton();
            this.log.info("Auditlog not available", new Object[0]);
        }
    }
}

