/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.configupdate;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.configuration.ConfigChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationLoader;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportConfigUpdateAction
extends TransportNodesAction<ConfigUpdateRequest, ConfigUpdateResponse, NodeConfigUpdateRequest, ConfigUpdateResponse.Node> {
    private final ClusterService clusterService;
    private final ConfigurationLoader cl;
    private final Provider<BackendRegistry> backendRegistry;
    private final ListMultimap<String, ConfigChangeListener> multimap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    @Inject
    public TransportConfigUpdateAction(final Provider<Client> clientProvider, Settings settings, ClusterName clusterName, final ThreadPool threadPool, final ClusterService clusterService, TransportService transportService, final ConfigurationLoader cl, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Provider<BackendRegistry> backendRegistry) {
        super(settings, "cluster:admin/searchguard/config/update", clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ConfigUpdateRequest.class, NodeConfigUpdateRequest.class, "management");
        this.cl = cl;
        this.clusterService = clusterService;
        this.backendRegistry = backendRegistry;
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void afterStart() {
                threadPool.executor("get").execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Client client = (Client)clientProvider.get();
                            TransportConfigUpdateAction.this.logger.debug("Node started, try to initialize it. Wait for at least yellow cluster state....", new Object[0]);
                            ClusterHealthResponse response = null;
                            try {
                                response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{"searchguard"}).waitForYellowStatus()).actionGet();
                            }
                            catch (Exception e1) {
                                TransportConfigUpdateAction.this.logger.debug("Catched a {} but we just try again ...", new Object[]{e1.toString()});
                            }
                            while (response == null || response.isTimedOut() || response.getStatus() == ClusterHealthStatus.RED) {
                                TransportConfigUpdateAction.this.logger.warn("searchguard index not healthy yet, we try again ... (Reason: {})", new Object[]{response == null ? "no response" : (response.isTimedOut() ? "timeout" : "other, maybe red cluster")});
                                try {
                                    Thread.sleep(3000L);
                                }
                                catch (InterruptedException e1) {
                                    // empty catch block
                                }
                                try {
                                    response = (ClusterHealthResponse)client.admin().cluster().health(new ClusterHealthRequest(new String[]{"searchguard"}).waitForYellowStatus()).actionGet();
                                }
                                catch (Exception e1) {
                                    TransportConfigUpdateAction.this.logger.debug("Catched again a {} but we just try again ...", new Object[]{e1.toString()});
                                }
                            }
                            Map<String, Settings> setn = cl.load(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"});
                            while (!setn.keySet().containsAll(Lists.newArrayList((Object[])new String[]{"config", "roles", "rolesmapping"}))) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                setn = cl.load(new String[]{"config", "roles", "rolesmapping", "internalusers", "actiongroups"});
                            }
                            TransportConfigUpdateAction transportConfigUpdateAction = TransportConfigUpdateAction.this;
                            synchronized (transportConfigUpdateAction) {
                                TransportConfigUpdateAction.this.logger.debug("Retrieved config on node startup and will now update config change listeners", new Object[0]);
                                for (String evt : setn.keySet()) {
                                    for (ConfigChangeListener cl : new ArrayList(TransportConfigUpdateAction.this.multimap.get((Object)evt))) {
                                        Settings settings = setn.get(evt);
                                        if (settings == null) continue;
                                        cl.onChange(evt, settings);
                                        TransportConfigUpdateAction.this.logger.debug("Updated {} for {} due to initial configuration on node '{}'", new Object[]{evt, cl.getClass().getSimpleName(), clusterService.localNode().getName()});
                                    }
                                }
                                TransportConfigUpdateAction.this.logger.info("Node '{}' initialized", new Object[]{clusterService.localNode().getName()});
                            }
                        }
                        catch (Exception e) {
                            TransportConfigUpdateAction.this.logger.error("Unexpected exception while initializing node " + e, (Throwable)e, new Object[0]);
                        }
                    }
                });
            }
        });
    }

    protected ConfigUpdateResponse newResponse(ConfigUpdateRequest request, AtomicReferenceArray nodesResponses) {
        ArrayList nodes = Lists.newArrayList();
        for (int i = 0; i < nodesResponses.length(); ++i) {
            Object resp = nodesResponses.get(i);
            if (!(resp instanceof ConfigUpdateResponse.Node)) continue;
            nodes.add((ConfigUpdateResponse.Node)((Object)resp));
        }
        return new ConfigUpdateResponse(this.clusterName, nodes.toArray(new ConfigUpdateResponse.Node[nodes.size()]));
    }

    protected NodeConfigUpdateRequest newNodeRequest(String nodeId, ConfigUpdateRequest request) {
        return new NodeConfigUpdateRequest(nodeId, request);
    }

    protected ConfigUpdateResponse.Node newNodeResponse() {
        return new ConfigUpdateResponse.Node(this.clusterService.localNode(), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigUpdateResponse.Node nodeOperation(NodeConfigUpdateRequest request) {
        ((BackendRegistry)this.backendRegistry.get()).invalidateCache();
        Map<String, Settings> setn = this.cl.load(request.request.getConfigTypes());
        if (setn.size() != request.request.getConfigTypes().length) {
            this.logger.error("Unable to load all configurations types. Loaded '{}' but should '{}' ", new Object[]{setn.keySet(), Arrays.toString(request.request.getConfigTypes())});
        }
        TransportConfigUpdateAction transportConfigUpdateAction = this;
        synchronized (transportConfigUpdateAction) {
            this.logger.debug("Retrieved config due to config update request and will now update config change listeners", new Object[0]);
            for (String evt : setn.keySet()) {
                for (ConfigChangeListener cl : new ArrayList(this.multimap.get((Object)evt))) {
                    Settings settings = setn.get(evt);
                    if (settings == null) continue;
                    cl.onChange(evt, settings);
                    this.logger.debug("Updated {} for {} due to node operation on node {}", new Object[]{evt, cl.getClass().getSimpleName(), this.clusterService.localNode().getName()});
                }
            }
            return new ConfigUpdateResponse.Node(this.clusterService.localNode(), setn.keySet().toArray(new String[0]));
        }
    }

    public void addConfigChangeListener(String event, ConfigChangeListener listener) {
        this.logger.debug("Add config listener {}", new Object[]{listener.getClass()});
        this.multimap.put((Object)event, (Object)listener);
    }

    protected boolean accumulateExceptions() {
        return false;
    }

    public static class NodeConfigUpdateRequest
    extends BaseNodeRequest {
        ConfigUpdateRequest request;

        public NodeConfigUpdateRequest() {
        }

        public NodeConfigUpdateRequest(String nodeId, ConfigUpdateRequest request) {
            super((BaseNodesRequest)request, nodeId);
            this.request = request;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new ConfigUpdateRequest();
            this.request.readFrom(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

