/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.auth.HTTPAuthenticator;
import com.floragunn.searchguard.user.AuthCredentials;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class HTTPBasicAuthenticator
implements HTTPAuthenticator {
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private final Settings settings;

    public HTTPBasicAuthenticator(Settings settings) {
        this.settings = settings;
    }

    @Override
    public AuthCredentials extractCredentials(RestRequest request) {
        String authorizationHeader = request.header("Authorization");
        boolean forceLogin = request.paramAsBoolean("force_login", false);
        if (authorizationHeader != null && !forceLogin) {
            if (!authorizationHeader.trim().toLowerCase().startsWith("basic ")) {
                this.log.warn("No 'Basic Authorization' header, send 401 and 'WWW-Authenticate Basic'", new Object[0]);
                return null;
            }
            String decodedBasicHeader = new String(DatatypeConverter.parseBase64Binary((String)authorizationHeader.split(" ")[1]), StandardCharsets.UTF_8);
            int firstColonIndex = decodedBasicHeader.indexOf(58);
            String username = null;
            String password = null;
            if (firstColonIndex > 0) {
                username = decodedBasicHeader.substring(0, firstColonIndex);
                password = decodedBasicHeader.length() - 1 != firstColonIndex ? decodedBasicHeader.substring(firstColonIndex + 1) : "";
            }
            if (username == null || password == null) {
                this.log.warn("Invalid 'Authorization' header, send 401 and 'WWW-Authenticate Basic'", new Object[0]);
                return null;
            }
            return new AuthCredentials(username, password.getBytes(StandardCharsets.UTF_8)).markComplete();
        }
        this.log.trace("No 'Authorization' header, send 401 and 'WWW-Authenticate Basic'", new Object[0]);
        return null;
    }

    @Override
    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials creds) {
        BytesRestResponse wwwAuthenticateResponse = new BytesRestResponse(RestStatus.UNAUTHORIZED);
        wwwAuthenticateResponse.addHeader("WWW-Authenticate", "Basic realm=\"Search Guard\"");
        channel.sendResponse((RestResponse)wwwAuthenticateResponse);
        return true;
    }

    @Override
    public String getType() {
        return "basic";
    }
}

