/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class AdminDNs {
    protected final ESLogger log = Loggers.getLogger(this.getClass());
    private final Set<LdapName> adminDn = new HashSet<LdapName>();
    private final ListMultimap<LdapName, String> allowedImpersonations = ArrayListMultimap.create();

    @Inject
    public AdminDNs(Settings settings) {
        String[] adminDnsA = settings.getAsArray("searchguard.authcz.admin_dn");
        for (int i = 0; i < adminDnsA.length; ++i) {
            String dn = adminDnsA[i];
            try {
                this.log.debug(dn, new Object[0]);
                this.adminDn.add(new LdapName(dn));
                continue;
            }
            catch (InvalidNameException e) {
                this.log.error("Unable to parse admin dn {} {}", (Throwable)e, new Object[]{dn, e});
            }
        }
        this.log.debug("Loaded {} admin DN's {}", new Object[]{this.adminDn.size(), this.adminDn});
        Map impersonationDns = settings.getGroups("searchguard.authcz.impersonation_dn");
        for (String dnString : impersonationDns.keySet()) {
            try {
                this.allowedImpersonations.putAll((Object)new LdapName(dnString), Arrays.asList(settings.getAsArray("searchguard.authcz.impersonation_dn." + dnString)));
            }
            catch (InvalidNameException e) {
                this.log.error("Unable to parse allowedImpersonations dn {} {}", (Throwable)e, new Object[]{dnString, e});
            }
        }
        this.log.debug("Loaded {} impersonation DN's {}", new Object[]{this.allowedImpersonations.size(), this.allowedImpersonations});
    }

    public boolean isAdmin(String dn) {
        if (dn == null) {
            return false;
        }
        try {
            return this.isAdmin(new LdapName(dn));
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    public boolean isAdmin(LdapName dn) {
        if (dn == null) {
            return false;
        }
        return this.adminDn.contains(dn);
    }

    public boolean isImpersonationAllowed(LdapName dn, String impersonated) {
        if (dn == null) {
            return false;
        }
        if (this.isAdmin(dn)) {
            return true;
        }
        return this.allowedImpersonations.containsEntry((Object)dn, (Object)"*") || this.allowedImpersonations.containsEntry((Object)dn, (Object)impersonated);
    }
}

