/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.configupdate;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ConfigUpdateResponse
extends BaseNodesResponse<Node> {
    public ConfigUpdateResponse() {
    }

    public ConfigUpdateResponse(ClusterName clusterName, Node[] nodes) {
        super(clusterName, (BaseNodeResponse[])nodes);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new Node[in.readVInt()];
        for (int i = 0; i < ((Node[])this.nodes).length; ++i) {
            ((Node[])this.nodes)[i] = Node.readNodeResponse(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((Node[])this.nodes).length);
        for (Node node : (Node[])this.nodes) {
            node.writeTo(out);
        }
    }

    public static class Node
    extends BaseNodeResponse {
        private String[] updatedConfigTypes;

        Node() {
        }

        Node(DiscoveryNode node, String[] updatedConfigTypes) {
            super(node);
            this.updatedConfigTypes = updatedConfigTypes == null ? null : Arrays.copyOf(updatedConfigTypes, updatedConfigTypes.length);
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.updatedConfigTypes = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.updatedConfigTypes);
        }

        public static Node readNodeResponse(StreamInput in) throws IOException {
            Node node = new Node();
            node.readFrom(in);
            return node;
        }

        public String toString() {
            return "Node [updatedConfigTypes=" + Arrays.toString(this.updatedConfigTypes) + ", remoteAddress()=" + this.remoteAddress() + "]";
        }

        public String[] getUpdatedConfigTypes() {
            return this.updatedConfigTypes == null ? null : Arrays.copyOf(this.updatedConfigTypes, this.updatedConfigTypes.length);
        }
    }
}

