/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.util.SSLCertificateHelper;
import com.floragunn.searchguard.ssl.util.SSLConfigConstants;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class SearchGuardKeyStore {
    private static final String DEFAULT_STORE_TYPE = "JKS";
    private static final String DEFAULT_STORE_PASSWORD = "changeit";
    private final Settings settings;
    private final ESLogger log = Loggers.getLogger(this.getClass());
    public final SslProvider sslHTTPProvider;
    public final SslProvider sslTransportServerProvider;
    public final SslProvider sslTransportClientProvider;
    private final boolean httpSSLEnabled;
    private final boolean transportSSLEnabled;
    private X509Certificate[] trustedHTTPCertificates;
    private X509Certificate[] trustedTransportCertificates;
    private X509Certificate[] httpKeystoreCert;
    private PrivateKey httpKeystoreKey;
    private X509Certificate[] transportKeystoreCert;
    private PrivateKey transportKeystoreKey;
    private ClientAuth httpClientAuthMode;
    private List<String> enabledHttpCiphersJDKProvider;
    private List<String> enabledHttpCiphersOpenSSLProvider;
    private List<String> enabledTransportCiphersJDKProvider;
    private List<String> enabledTransportCiphersOpenSSLProvider;
    private SslContext httpSslContext;
    private SslContext transportServerSslContext;
    private SslContext transportClientSslContext;

    private void printJCEWarnings() {
        try {
            int aesMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (aesMaxKeyLength < 256) {
                this.log.info("AES-256 not supported, max key length for AES is " + aesMaxKeyLength + " bit.. That is not an issue, it just limits possible encryption strength. To enable AES 256 install 'Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files'", new Object[0]);
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("AES encryption not supported (SG 1). " + e, new Object[0]);
        }
    }

    @Inject
    public SearchGuardKeyStore(Settings settings) {
        this.settings = settings;
        this.httpSSLEnabled = settings.getAsBoolean("searchguard.ssl.http.enabled", Boolean.valueOf(false));
        this.transportSSLEnabled = settings.getAsBoolean("searchguard.ssl.transport.enabled", Boolean.valueOf(true));
        boolean useOpenSSLForHttpIfAvailable = settings.getAsBoolean("searchguard.ssl.http.enable_openssl_if_available", Boolean.valueOf(true));
        boolean useOpenSSLForTransportIfAvailable = settings.getAsBoolean("searchguard.ssl.transport.enable_openssl_if_available", Boolean.valueOf(true));
        if (this.httpSSLEnabled && useOpenSSLForHttpIfAvailable) {
            this.sslHTTPProvider = SslContext.defaultServerProvider();
            this.logOpenSSLInfos();
        } else {
            this.sslHTTPProvider = this.httpSSLEnabled ? SslProvider.JDK : null;
        }
        if (this.transportSSLEnabled && useOpenSSLForTransportIfAvailable) {
            this.sslTransportClientProvider = SslContext.defaultClientProvider();
            this.sslTransportServerProvider = SslContext.defaultServerProvider();
            this.logOpenSSLInfos();
        } else if (this.transportSSLEnabled) {
            this.sslTransportClientProvider = this.sslTransportServerProvider = SslProvider.JDK;
        } else {
            this.sslTransportServerProvider = null;
            this.sslTransportClientProvider = null;
        }
        this.initEnabledSSLCiphers();
        this.initSSLConfig();
        this.printJCEWarnings();
        this.log.info("sslTransportClientProvider:{} with ciphers {}", new Object[]{this.sslTransportClientProvider, this.getEnabledSSLCiphers(this.sslTransportClientProvider, false)});
        this.log.info("sslTransportServerProvider:{} with ciphers {}", new Object[]{this.sslTransportServerProvider, this.getEnabledSSLCiphers(this.sslTransportServerProvider, false)});
        this.log.info("sslHTTPProvider:{} with ciphers {}", new Object[]{this.sslHTTPProvider, this.getEnabledSSLCiphers(this.sslHTTPProvider, true)});
        this.log.info("sslTransport protocols {}", new Object[]{Arrays.asList(SSLConfigConstants.getSecureSSLProtocols(settings, false))});
        this.log.info("sslHTTP protocols {}", new Object[]{Arrays.asList(SSLConfigConstants.getSecureSSLProtocols(settings, true))});
        if (this.transportSSLEnabled && (this.getEnabledSSLCiphers(this.sslTransportClientProvider, false).isEmpty() || this.getEnabledSSLCiphers(this.sslTransportServerProvider, false).isEmpty())) {
            throw new ElasticsearchSecurityException("no valid cipher suites for transport protocol", new Object[0]);
        }
        if (this.httpSSLEnabled && this.getEnabledSSLCiphers(this.sslHTTPProvider, true).isEmpty()) {
            throw new ElasticsearchSecurityException("no valid cipher suites for http", new Object[0]);
        }
        if (this.transportSSLEnabled && SSLConfigConstants.getSecureSSLProtocols(settings, false).length == 0) {
            throw new ElasticsearchSecurityException("no ssl protocols for transport protocol", new Object[0]);
        }
        if (this.httpSSLEnabled && SSLConfigConstants.getSecureSSLProtocols(settings, true).length == 0) {
            throw new ElasticsearchSecurityException("no ssl protocols for http", new Object[0]);
        }
    }

    private void initSSLConfig() {
        boolean client;
        Environment env = new Environment(this.settings);
        this.log.info("Config directory is {}/, from there the key- and truststore files are resolved relatively", new Object[]{env.configFile().toAbsolutePath()});
        if (this.transportSSLEnabled) {
            String keystoreFilePath = env.configFile().resolve(this.settings.get("searchguard.ssl.transport.keystore_filepath", "")).toAbsolutePath().toString();
            String keystoreType = this.settings.get("searchguard.ssl.transport.keystore_type", DEFAULT_STORE_TYPE);
            String keystorePassword = this.settings.get("searchguard.ssl.transport.keystore_password", DEFAULT_STORE_PASSWORD);
            String keystoreAlias = this.settings.get("searchguard.ssl.transport.keystore_alias", null);
            String truststoreFilePath = env.configFile().resolve(this.settings.get("searchguard.ssl.transport.truststore_filepath", "")).toAbsolutePath().toString();
            if (this.settings.get("searchguard.ssl.transport.keystore_filepath", null) == null) {
                throw new ElasticsearchException("searchguard.ssl.transport.keystore_filepath must be set if transport ssl is reqested.", new Object[0]);
            }
            SearchGuardKeyStore.checkStorePath(keystoreFilePath);
            if (this.settings.get("searchguard.ssl.transport.truststore_filepath", null) == null) {
                throw new ElasticsearchException("searchguard.ssl.transport.truststore_filepath must be set if transport ssl is reqested.", new Object[0]);
            }
            SearchGuardKeyStore.checkStorePath(truststoreFilePath);
            String truststoreType = this.settings.get("searchguard.ssl.transport.truststore_type", DEFAULT_STORE_TYPE);
            String truststorePassword = this.settings.get("searchguard.ssl.transport.truststore_password", DEFAULT_STORE_PASSWORD);
            String truststoreAlias = this.settings.get("searchguard.ssl.transport.truststore_alias", null);
            try {
                KeyStore ks = KeyStore.getInstance(keystoreType);
                ks.load(new FileInputStream(new File(keystoreFilePath)), keystorePassword == null || keystorePassword.length() == 0 ? null : keystorePassword.toCharArray());
                this.transportKeystoreCert = SSLCertificateHelper.exportCertificateChain(ks, keystoreAlias);
                this.transportKeystoreKey = SSLCertificateHelper.exportDecryptedKey(ks, keystoreAlias, keystorePassword == null || keystorePassword.length() == 0 ? null : keystorePassword.toCharArray());
                if (this.transportKeystoreKey == null) {
                    throw new ElasticsearchException("No key found in " + keystoreFilePath + " with alias " + keystoreAlias, new Object[0]);
                }
                if (this.transportKeystoreCert == null || this.transportKeystoreCert.length <= 0) {
                    throw new ElasticsearchException("No certificates found in " + keystoreFilePath + " with alias " + keystoreAlias, new Object[0]);
                }
                KeyStore ts = KeyStore.getInstance(truststoreType);
                ts.load(new FileInputStream(new File(truststoreFilePath)), truststorePassword == null || truststorePassword.length() == 0 ? null : truststorePassword.toCharArray());
                this.trustedTransportCertificates = SSLCertificateHelper.exportCertificateChain(ts, truststoreAlias);
                if (this.trustedTransportCertificates == null) {
                    throw new ElasticsearchException("No truststore configured for server", new Object[0]);
                }
                SslContextBuilder sslServerContextBuilder = SslContextBuilder.forServer((PrivateKey)this.transportKeystoreKey, (X509Certificate[])this.transportKeystoreCert).ciphers(this.getEnabledSSLCiphers(this.sslTransportServerProvider, false)).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).clientAuth(ClientAuth.REQUIRE).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(this.sslTransportServerProvider).trustManager(this.trustedTransportCertificates);
                this.transportServerSslContext = this.buildSSLContext(sslServerContextBuilder);
                if (this.trustedTransportCertificates == null) {
                    throw new ElasticsearchException("No truststore configured for client", new Object[0]);
                }
                SslContextBuilder sslClientContextBuilder = SslContextBuilder.forClient().ciphers(this.getEnabledSSLCiphers(this.sslTransportClientProvider, false)).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(this.sslTransportClientProvider).trustManager(this.trustedTransportCertificates).keyManager(this.transportKeystoreKey, this.transportKeystoreCert);
                this.transportClientSslContext = this.buildSSLContext(sslClientContextBuilder);
            }
            catch (Exception e) {
                throw new ElasticsearchSecurityException("Error while initializing transport SSL layer: " + e.toString(), (Throwable)e, new Object[0]);
            }
        }
        boolean bl = client = !"node".equals(this.settings.get("client.type"));
        if (!client && this.httpSSLEnabled) {
            String keystoreFilePath = env.configFile().resolve(this.settings.get("searchguard.ssl.http.keystore_filepath", "")).toAbsolutePath().toString();
            String keystoreType = this.settings.get("searchguard.ssl.http.keystore_type", DEFAULT_STORE_TYPE);
            String keystorePassword = this.settings.get("searchguard.ssl.http.keystore_password", DEFAULT_STORE_PASSWORD);
            String keystoreAlias = this.settings.get("searchguard.ssl.http.keystore_alias", null);
            this.httpClientAuthMode = ClientAuth.valueOf((String)this.settings.get("searchguard.ssl.http.clientauth_mode", ClientAuth.OPTIONAL.toString()));
            String _enforceHTTPClientAuth = this.settings.get("searchguard.ssl.http.enforce_clientauth");
            if (_enforceHTTPClientAuth != null) {
                this.log.error("{} is deprecated and replaced by {}", new Object[]{"searchguard.ssl.http.enforce_clientauth", "searchguard.ssl.http.clientauth_mode"});
                throw new RuntimeException("searchguard.ssl.http.enforce_clientauth is deprecated");
            }
            this.log.info("HTTPS client auth mode {}", new Object[]{this.httpClientAuthMode});
            String truststoreFilePath = env.configFile().resolve(this.settings.get("searchguard.ssl.http.truststore_filepath", "")).toAbsolutePath().toString();
            if (this.settings.get("searchguard.ssl.http.keystore_filepath", null) == null) {
                throw new ElasticsearchException("searchguard.ssl.http.keystore_filepath must be set if https is reqested.", new Object[0]);
            }
            SearchGuardKeyStore.checkStorePath(keystoreFilePath);
            if (this.httpClientAuthMode == ClientAuth.REQUIRE && this.settings.get("searchguard.ssl.http.truststore_filepath", null) == null) {
                throw new ElasticsearchException("searchguard.ssl.http.truststore_filepath must be set if http ssl and client auth is reqested.", new Object[0]);
            }
            try {
                KeyStore ks = KeyStore.getInstance(keystoreType);
                ks.load(new FileInputStream(new File(keystoreFilePath)), keystorePassword == null || keystorePassword.length() == 0 ? null : keystorePassword.toCharArray());
                this.httpKeystoreCert = SSLCertificateHelper.exportCertificateChain(ks, keystoreAlias);
                this.httpKeystoreKey = SSLCertificateHelper.exportDecryptedKey(ks, keystoreAlias, keystorePassword == null || keystorePassword.length() == 0 ? null : keystorePassword.toCharArray());
                if (this.httpKeystoreKey == null) {
                    throw new ElasticsearchException("No key found in " + keystoreFilePath + " with alias " + keystoreAlias, new Object[0]);
                }
                if (this.httpKeystoreCert == null || this.httpKeystoreCert.length <= 0) {
                    throw new ElasticsearchException("No certificates found in " + keystoreFilePath + " with alias " + keystoreAlias, new Object[0]);
                }
                if (this.settings.get("searchguard.ssl.http.truststore_filepath", null) != null) {
                    SearchGuardKeyStore.checkStorePath(truststoreFilePath);
                    String truststoreType = this.settings.get("searchguard.ssl.http.truststore_type", DEFAULT_STORE_TYPE);
                    String truststorePassword = this.settings.get("searchguard.ssl.http.truststore_password", DEFAULT_STORE_PASSWORD);
                    String truststoreAlias = this.settings.get("searchguard.ssl.http.truststore_alias", null);
                    KeyStore ts = KeyStore.getInstance(truststoreType);
                    ts.load(new FileInputStream(new File(truststoreFilePath)), truststorePassword == null || truststorePassword.length() == 0 ? null : truststorePassword.toCharArray());
                    this.trustedHTTPCertificates = SSLCertificateHelper.exportCertificateChain(ts, truststoreAlias);
                }
                SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((PrivateKey)this.httpKeystoreKey, (X509Certificate[])this.httpKeystoreCert).ciphers(this.getEnabledSSLCiphers(this.sslHTTPProvider, true)).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).clientAuth(Objects.requireNonNull(this.httpClientAuthMode)).sessionCacheSize(0L).sessionTimeout(0L).sslProvider(this.sslHTTPProvider);
                if (this.trustedHTTPCertificates != null && this.trustedHTTPCertificates.length > 0) {
                    sslContextBuilder.trustManager(this.trustedHTTPCertificates);
                }
                this.httpSslContext = this.buildSSLContext(sslContextBuilder);
            }
            catch (Exception e) {
                throw new ElasticsearchSecurityException("Error while initializing HTTP SSL layer: " + e.toString(), (Throwable)e, new Object[0]);
            }
        }
    }

    public SSLEngine createHTTPSSLEngine() throws SSLException {
        SSLEngine engine = this.httpSslContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        engine.setEnabledProtocols(SSLConfigConstants.getSecureSSLProtocols(this.settings, true));
        return engine;
    }

    public SSLEngine createServerTransportSSLEngine() throws SSLException {
        SSLEngine engine = this.transportServerSslContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        engine.setEnabledProtocols(SSLConfigConstants.getSecureSSLProtocols(this.settings, false));
        return engine;
    }

    public SSLEngine createClientTransportSSLEngine(String peerHost, int peerPort) throws SSLException {
        if (peerHost != null) {
            SSLEngine engine = this.transportClientSslContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, peerHost, peerPort);
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParams);
            engine.setEnabledProtocols(SSLConfigConstants.getSecureSSLProtocols(this.settings, false));
            return engine;
        }
        SSLEngine engine = this.transportClientSslContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        engine.setEnabledProtocols(SSLConfigConstants.getSecureSSLProtocols(this.settings, false));
        return engine;
    }

    private void logOpenSSLInfos() {
        if (OpenSsl.isAvailable()) {
            this.log.info("Open SSL " + OpenSsl.versionString() + " available", new Object[0]);
            this.log.debug("Open SSL available ciphers " + OpenSsl.availableCipherSuites(), new Object[0]);
        } else {
            this.log.info("Open SSL not available (this is not an error, we simply fallback to built-in JDK SSL) because of " + OpenSsl.unavailabilityCause(), new Object[0]);
        }
    }

    private List<String> getEnabledSSLCiphers(SslProvider provider, boolean http) {
        if (provider == null) {
            return Collections.emptyList();
        }
        if (http) {
            return provider == SslProvider.JDK ? this.enabledHttpCiphersJDKProvider : this.enabledHttpCiphersOpenSSLProvider;
        }
        return provider == SslProvider.JDK ? this.enabledTransportCiphersJDKProvider : this.enabledTransportCiphersOpenSSLProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEnabledSSLCiphers() {
        ArrayList<String> jdkSupportedCiphers;
        SSLContext serverContext;
        List<String> secureSSLCiphers = SSLConfigConstants.getSecureSSLCiphers(this.settings, true);
        if (OpenSsl.isAvailable()) {
            HashSet<String> openSSLSecureCiphers = new HashSet<String>();
            for (String secure : secureSSLCiphers) {
                if (!OpenSsl.isCipherSuiteAvailable((String)secure)) continue;
                openSSLSecureCiphers.add(secure);
            }
            this.enabledHttpCiphersOpenSSLProvider = Collections.unmodifiableList(new ArrayList(openSSLSecureCiphers));
        } else {
            this.enabledHttpCiphersOpenSSLProvider = Collections.emptyList();
        }
        SSLEngine engine = null;
        try {
            serverContext = SSLContext.getInstance("TLS");
            serverContext.init(null, null, null);
            engine = serverContext.createSSLEngine();
            jdkSupportedCiphers = new ArrayList<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            jdkSupportedCiphers.retainAll(secureSSLCiphers);
            engine.setEnabledCipherSuites(jdkSupportedCiphers.toArray(new String[0]));
            this.enabledHttpCiphersJDKProvider = Collections.unmodifiableList(Arrays.asList(engine.getEnabledCipherSuites()));
        }
        catch (Exception e) {
            this.enabledHttpCiphersJDKProvider = Collections.emptyList();
        }
        finally {
            if (engine != null) {
                try {
                    engine.closeInbound();
                }
                catch (SSLException e) {
                    e.printStackTrace();
                }
                engine.closeOutbound();
            }
        }
        secureSSLCiphers = SSLConfigConstants.getSecureSSLCiphers(this.settings, false);
        if (OpenSsl.isAvailable()) {
            HashSet<String> openSSLSecureCiphers = new HashSet<String>();
            for (String secure : secureSSLCiphers) {
                if (!OpenSsl.isCipherSuiteAvailable((String)secure)) continue;
                openSSLSecureCiphers.add(secure);
            }
            this.enabledTransportCiphersOpenSSLProvider = Collections.unmodifiableList(new ArrayList(openSSLSecureCiphers));
        } else {
            this.enabledTransportCiphersOpenSSLProvider = Collections.emptyList();
        }
        try {
            serverContext = SSLContext.getInstance("TLS");
            serverContext.init(null, null, null);
            engine = serverContext.createSSLEngine();
            jdkSupportedCiphers = new ArrayList<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            jdkSupportedCiphers.retainAll(secureSSLCiphers);
            engine.setEnabledCipherSuites(jdkSupportedCiphers.toArray(new String[0]));
            this.enabledTransportCiphersJDKProvider = Collections.unmodifiableList(Arrays.asList(engine.getEnabledCipherSuites()));
        }
        catch (Exception e) {
            this.enabledTransportCiphersJDKProvider = Collections.emptyList();
        }
        finally {
            if (engine != null) {
                try {
                    engine.closeInbound();
                }
                catch (SSLException e) {
                    e.printStackTrace();
                }
                engine.closeOutbound();
            }
        }
    }

    private SslContext buildSSLContext(final SslContextBuilder sslContextBuilder) throws SSLException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        SslContext sslContext = null;
        try {
            sslContext = AccessController.doPrivileged(new PrivilegedExceptionAction<SslContext>(){

                @Override
                public SslContext run() throws Exception {
                    return sslContextBuilder.build();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SSLException)e.getCause();
        }
        return sslContext;
    }

    private static void checkStorePath(String keystoreFilePath) {
        if (Files.isDirectory(Paths.get(keystoreFilePath, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new ElasticsearchException("Is a directory: " + keystoreFilePath + " Expected file!", new Object[0]);
        }
        if (!Files.isReadable(Paths.get(keystoreFilePath, new String[0]))) {
            throw new ElasticsearchException("Unable to read " + keystoreFilePath + " (" + Paths.get(keystoreFilePath, new String[0]) + ") Please make sure this files exists and is readable regarding to permissions", new Object[0]);
        }
    }
}

