/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RoleBuilder {
    private SearchGuardRoles.Roles role = new SearchGuardRoles.Roles();
    private String name;
    private Set<String> clusters = new HashSet<String>();
    private Map<String, HashMap<String, HashSet<String>>> indices = new HashMap<String, HashMap<String, HashSet<String>>>();

    public RoleBuilder(String name) {
        this.name = name;
    }

    public RoleBuilder setClusters(List<String> clusters) {
        if (clusters != null) {
            this.clusters = new HashSet<String>(clusters);
        }
        return this;
    }

    public RoleBuilder setClusters(String[] clusters) {
        return this.setClusters(Arrays.asList(clusters));
    }

    public RoleBuilder addIndex(String index) {
        this.indices.put(index, new HashMap());
        return this;
    }

    public RoleBuilder setActions(String index, String type, List<String> actions) {
        if (!this.indices.containsKey(index)) {
            this.addIndex(index);
        }
        this.indices.get(index).put(type, new HashSet<String>(actions));
        return this;
    }

    public RoleBuilder setActions(String index, String type, String[] actions) {
        return this.setActions(index, type, Arrays.asList(actions));
    }

    public SearchGuardRoles.Roles build() {
        this.role.setName(this.name);
        this.role.setCluster(new ArrayList<String>(this.clusters));
        ArrayList<SearchGuardRoles.Roles.Indices> roleIndices = new ArrayList<SearchGuardRoles.Roles.Indices>();
        for (String indexKey : this.indices.keySet()) {
            SearchGuardRoles.Roles.Indices index = new SearchGuardRoles.Roles.Indices();
            index.setIndex(indexKey);
            ArrayList<SearchGuardRoles.Roles.Indices.Type> types = new ArrayList<SearchGuardRoles.Roles.Indices.Type>();
            for (String typeKey : this.indices.get(indexKey).keySet()) {
                SearchGuardRoles.Roles.Indices.Type type = new SearchGuardRoles.Roles.Indices.Type();
                type.setType(typeKey);
                type.setActions(new ArrayList<String>((Collection)this.indices.get(indexKey).get(typeKey)));
                types.add(type);
            }
            index.setTypes(types);
            roleIndices.add(index);
        }
        this.role.setIndices(roleIndices);
        return this.role;
    }
}

