/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.transport;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.configuration.RequestHolder;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLTransportService;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.LogHelper;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

public class SearchGuardTransportService
extends SearchGuardSSLTransportService {
    protected final ESLogger log = Loggers.getLogger(((Object)((Object)this)).getClass());
    private final Provider<BackendRegistry> backendRegistry;
    private final AuditLog auditLog;
    private final String certOid;

    @Inject
    public SearchGuardTransportService(Settings settings, Transport transport, ThreadPool threadPool, Provider<BackendRegistry> backendRegistry, AuditLog auditLog) {
        super(settings, transport, threadPool);
        this.backendRegistry = backendRegistry;
        this.auditLog = auditLog;
        this.certOid = settings.get("searchguard.cert.oid", "1.2.3.4.5.5");
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) {
        this.attachHeaders(action, request);
        super.sendRequest(node, action, request, handler);
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        this.attachHeaders(action, request);
        super.sendRequest(node, action, request, options, handler);
    }

    private void attachHeaders(String action, TransportRequest request) {
        User user;
        Object remoteAdr = request.getFromContext((Object)"_sg_remote_address");
        if (remoteAdr != null && remoteAdr instanceof InetSocketTransportAddress) {
            request.putHeader("_sg_remote_address_header", (Object)Base64Helper.serializeObject(((InetSocketTransportAddress)remoteAdr).address()));
        }
        if ((user = (User)request.getFromContext((Object)"_sg_user")) == null && request.remoteAddress() == null) {
            user = User.SG_INTERNAL;
        }
        if (user == null) {
            throw new ElasticsearchSecurityException("user must not be null here for " + action + " " + LogHelper.toString((ContextAndHeaderHolder)request), new Object[0]);
        }
        request.putHeader("_sg_user_header", (Object)Base64Helper.serializeObject(user));
    }

    protected void addAdditionalContextValues(String action, TransportRequest request, X509Certificate[] certs) throws Exception {
        boolean isInterClusterRequest = false;
        Collection<List<?>> ianList = certs[0].getSubjectAlternativeNames();
        if (ianList != null) {
            StringBuilder sb = new StringBuilder();
            for (List<?> ian : ianList) {
                if (ian == null) continue;
                Iterator<?> iterator = ian.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    if (id == 8) {
                        Object value = iterator.next();
                        if (value == null) continue;
                        if (value instanceof String) {
                            sb.append(id + "::" + value);
                            continue;
                        }
                        if (value instanceof byte[]) {
                            this.log.error("Unable to handle OID san {} with value {} of type byte[] (ASN.1 DER not supported here)", new Object[]{id, Arrays.toString((byte[])value)});
                            continue;
                        }
                        this.log.error("Unable to handle OID san {} with value {} of type {}", new Object[]{id, value, value.getClass()});
                        continue;
                    }
                    iterator.next();
                }
            }
            if (sb.indexOf("8::" + this.certOid) >= 0) {
                isInterClusterRequest = true;
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("No issuer alternative names (san) found", new Object[0]);
        }
        if (isInterClusterRequest) {
            if (this.log.isTraceEnabled() && !action.startsWith("internal:")) {
                this.log.trace("Is inter cluster request ({}/{}/{})", new Object[]{action, request.getClass(), request.remoteAddress()});
            }
            request.putInContext((Object)"_sg_ssl_transport_intercluster_request", (Object)Boolean.TRUE);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("Is not an inter cluster request", new Object[0]);
        }
        super.addAdditionalContextValues(action, request, certs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceivedDecorate(TransportRequest request, TransportRequestHandler handler, TransportChannel transportChannel, Task task) throws Exception {
        try {
            RequestHolder context = new RequestHolder(request);
            RequestHolder.setCurrent(context);
            request.putInContext((Object)"_sg_channel_type", (Object)transportChannel.getChannelType());
            if (transportChannel.getChannelType().equals("local") || transportChannel.getChannelType().equals("direct")) {
                super.messageReceivedDecorate(request, handler, transportChannel, task);
                return;
            }
            if (!SearchGuardTransportService.isInterClusterRequest(request) && (transportChannel.action().startsWith("internal:") || transportChannel.action().contains("["))) {
                this.auditLog.logMissingPrivileges(transportChannel.action(), request);
                this.log.error("Internal or shard requests not allowed from a non-server node for transport type " + transportChannel.getChannelType(), new Object[0]);
                transportChannel.sendResponse((Throwable)new ElasticsearchSecurityException("Internal or shard requests not allowed from a non-server node for transport type " + transportChannel.getChannelType(), new Object[0]));
                return;
            }
            String principal = null;
            principal = (String)request.getFromContext((Object)"_sg_ssl_transport_principal");
            if (principal == null) {
                ElasticsearchSecurityException ex = new ElasticsearchSecurityException("No SSL client certificates found for transport type " + transportChannel.getChannelType() + ". Search Guard needs the Search Guard SSL plugin to be installed", new Object[0]);
                this.auditLog.logSSLException(request, (Throwable)ex, transportChannel.action());
                this.log.error("No SSL client certificates found for transport type " + transportChannel.getChannelType() + ". Search Guard needs the Search Guard SSL plugin to be installed", new Object[0]);
                transportChannel.sendResponse((Throwable)ex);
                return;
            }
            if (SearchGuardTransportService.isInterClusterRequest(request)) {
                String userHeader = (String)request.getHeader("_sg_user_header");
                if (Strings.isNullOrEmpty((String)userHeader)) {
                    request.putInContext((Object)"_sg_user", (Object)User.SG_INTERNAL);
                } else {
                    request.putInContext((Object)"_sg_user", (Object)Objects.requireNonNull((User)Base64Helper.deserializeObject(userHeader)));
                }
                String originalRemoteAddress = (String)request.getHeader("_sg_remote_address_header");
                if (!Strings.isNullOrEmpty((String)originalRemoteAddress)) {
                    request.putInContext((Object)"_sg_remote_address", (Object)Base64Helper.deserializeObject(originalRemoteAddress));
                }
            } else {
                try {
                    HeaderHelper.checkSGHeader(request);
                }
                catch (Exception e) {
                    this.auditLog.logBadHeaders(request);
                    this.log.error("Error validating headers " + e, (Throwable)e, new Object[0]);
                    transportChannel.sendResponse((Throwable)ExceptionsHelper.convertToElastic((Throwable)e));
                    RequestHolder.removeCurrent();
                    return;
                }
                request.putInContext((Object)"_sg_user", (Object)new User(principal));
                try {
                    ((BackendRegistry)this.backendRegistry.get()).impersonate(request, transportChannel);
                }
                catch (Exception e) {
                    this.log.error("Error doing impersonation " + e, (Throwable)e, new Object[0]);
                    this.auditLog.logFailedLogin(principal, request);
                    transportChannel.sendResponse((Throwable)ExceptionsHelper.convertToElastic((Throwable)e));
                    RequestHolder.removeCurrent();
                    return;
                }
                if (!((BackendRegistry)this.backendRegistry.get()).authenticate(request)) {
                    this.auditLog.logFailedLogin(principal, request);
                    this.log.error("Cannot authenticate {}", new Object[]{request.getFromContext((Object)"_sg_user")});
                    transportChannel.sendResponse((Throwable)new ElasticsearchSecurityException("Cannot authenticate " + request.getFromContext((Object)"_sg_user"), new Object[0]));
                    return;
                }
                TransportAddress originalRemoteAddress = request.remoteAddress();
                if (originalRemoteAddress != null && originalRemoteAddress instanceof InetSocketTransportAddress) {
                    request.putInContext((Object)"_sg_remote_address", (Object)originalRemoteAddress);
                } else {
                    this.log.error("Request has no proper remote address {}", new Object[]{originalRemoteAddress});
                    transportChannel.sendResponse((Throwable)new ElasticsearchException("Request has no proper remote address", new Object[0]));
                    return;
                }
            }
            super.messageReceivedDecorate(request, handler, transportChannel, task);
        }
        finally {
            RequestHolder.removeCurrent();
        }
    }

    protected void errorThrown(Throwable t, TransportRequest request, String action) {
        this.auditLog.logSSLException(request, t, action);
    }

    private static boolean isInterClusterRequest(TransportRequest request) {
        return request.getFromContext((Object)"_sg_ssl_transport_intercluster_request") == Boolean.TRUE;
    }
}

